/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import forestry.core.utils.Translator;
import java.io.File;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.text.WordUtils;

public class LocalizedConfiguration
extends Configuration {
    public LocalizedConfiguration(File file, String configVersion) {
        super(file, configVersion);
    }

    public Configuration setCategoryLanguageKey(String categoryName) {
        String categoryKey = "for.config" + categoryName;
        return super.setCategoryLanguageKey(categoryName, categoryKey);
    }

    public boolean getBoolean(String category, String name, boolean defaultValue, String comment) {
        Property prop = this.get(category, name, defaultValue);
        prop.setComment(comment + " [default: " + defaultValue + "]");
        return prop.getBoolean(defaultValue);
    }

    public boolean getBooleanLocalized(String category, String name, boolean defaultValue) {
        return this.getBooleanLocalizedFormatted(category, name, defaultValue, "");
    }

    public boolean getBooleanLocalizedFormatted(String category, String name, boolean defaultValue, Object ... args) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = Translator.translateToLocalFormatted(commentKey, args);
        return this.getBoolean(name, category, defaultValue, comment, langKey);
    }

    public String getStringLocalized(String category, String name, String defaultValue) {
        return this.getStringLocalized(category, name, defaultValue, new String[0]);
    }

    public String getStringLocalized(String category, String name, String defaultValue, String[] validValues) {
        return this.getStringLocalizedFormatted(category, name, defaultValue, validValues, "");
    }

    public String getStringLocalizedFormatted(String category, String name, String defaultValue, String[] validValues, Object ... args) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = Translator.translateToLocalFormatted(commentKey, args);
        Property prop = this.get(category, name, defaultValue);
        prop.setValidValues(validValues);
        prop.setLanguageKey(langKey);
        prop.setComment(comment + this.getValidOptions(prop));
        return prop.getString();
    }

    public <T extends Enum<T>> T getEnumLocalized(String category, String name, T defaultValue, T[] validEnumValues) {
        T enumValue;
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        Property prop = this.get(category, name, defaultValue.name());
        String[] validValues = new String[validEnumValues.length];
        for (int i = 0; i < validEnumValues.length; ++i) {
            enumValue = validEnumValues[i];
            validValues[i] = ((Enum)enumValue).name();
        }
        prop.setValidValues(validValues);
        prop.setLanguageKey(langKey);
        prop.setComment(comment + " [default: " + defaultValue + "] [valid: " + Arrays.toString(prop.getValidValues()) + "]");
        String stringValue = prop.getString();
        enumValue = defaultValue;
        for (int i = 0; i < validValues.length; ++i) {
            if (!stringValue.equals(validValues[i])) continue;
            enumValue = validEnumValues[i];
        }
        return enumValue;
    }

    public String[] getStringListLocalized(String category, String name, String[] defaultValue) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = "";
        if (Translator.canTranslateToLocal(commentKey)) {
            comment = Translator.translateToLocal(commentKey);
        }
        return super.getStringList(name, category, defaultValue, comment);
    }

    public String[] getStringListLocalized(String category, String name, String[] defaultValue, String[] validValues) {
        return this.getStringListLocalizedFormatted(category, name, defaultValue, validValues, "");
    }

    public String[] getStringListLocalizedFormatted(String category, String name, String[] defaultValue, String[] validValues, Object ... args) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = Translator.translateToLocalFormatted(commentKey, args);
        Property prop = this.get(category, name, defaultValue);
        prop.setLanguageKey(langKey);
        prop.setValidValues(validValues);
        prop.setComment(comment + this.getValidOptions(prop));
        return prop.getStringList();
    }

    private String getValidOptions(Property prop) {
        String defautValue = prop.isList() ? Arrays.toString(prop.getDefaults()) : prop.getDefault();
        String ret = " [default: " + defautValue + "]";
        if (prop.getValidValues().length != 0) {
            ret = ret + " [valid: " + Arrays.toString(prop.getValidValues()) + "]";
        }
        return ret;
    }

    public float getFloatLocalized(String category, String name, float defaultValue, float minValue, float maxValue) {
        return this.getFloatLocalizedFormatted(category, name, defaultValue, minValue, maxValue, "");
    }

    public float getFloatLocalizedFormatted(String category, String name, float defaultValue, float minValue, float maxValue, Object ... args) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = Translator.translateToLocalFormatted(commentKey, args);
        return this.getFloat(name, category, defaultValue, minValue, maxValue, comment, langKey);
    }

    public int getIntLocalized(String category, String name, int defaultValue, int minValue, int maxValue) {
        return this.getIntLocalizedFormatted(category, name, defaultValue, minValue, maxValue, "");
    }

    public int getIntLocalizedFormatted(String category, String name, int defaultValue, int minValue, int maxValue, Object ... args) {
        String langKey = "for.config." + category + '.' + name;
        String commentKey = langKey + '.' + "comment";
        String comment = Translator.translateToLocalFormatted(commentKey, args);
        return this.getInt(name, category, defaultValue, minValue, maxValue, comment, langKey);
    }

    public void addCategoryCommentLocalized(String category) {
        String langKey = "for.config." + category + '.' + "category_comment";
        this.setCategoryComment(category, WordUtils.wrap((String)Translator.translateToLocal(langKey), (int)100));
    }
}

