/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.genetics.IDatabasePlugin;
import forestry.api.genetics.IDatabaseTab;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.events.GuiEvent;
import forestry.core.genetics.analyzer.AnalyzerTab;
import forestry.core.gui.Drawable;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.elements.GeneticAnalyzer;
import forestry.core.gui.elements.GuiElement;
import forestry.core.gui.elements.layouts.VerticalLayout;
import forestry.core.utils.SoundUtil;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

public class GeneticAnalyzerTabs
extends VerticalLayout {
    private static final Drawable SELECTED_BACKGROUND = new Drawable(GeneticAnalyzer.TEXTURE, 0, 166, 35, 26);
    private static final Drawable UNSELECTED_BACKGROUND = new Drawable(GeneticAnalyzer.TEXTURE, 0, 192, 35, 26);
    @Nullable
    public IDatabasePlugin databasePlugin;
    public final GeneticAnalyzer analyzer;
    private int selected = 0;

    public GeneticAnalyzerTabs(int xPos, int yPos, GeneticAnalyzer analyzer) {
        super(xPos, yPos, 35);
        this.setDistance(2);
        this.analyzer = analyzer;
        IDatabaseTab[] tabs = this.getTabs();
        for (int i = 0; i < 4; ++i) {
            IDatabaseTab tab = tabs.length > i ? tabs[i] : null;
            Tab element = new Tab(0, 0, i);
            element.setTab(tab);
            this.add(element);
        }
    }

    private void select(int index) {
        this.selected = index;
    }

    public IDatabaseTab getSelected() {
        IGuiElement element = (IGuiElement)this.elements.get(this.selected);
        if (!(element instanceof Tab) || !element.isVisible()) {
            return AnalyzerTab.ANALYZE;
        }
        return ((Tab)element).tab;
    }

    public void setPlugin(@Nullable IDatabasePlugin plugin) {
        if (this.databasePlugin != plugin) {
            this.selected = 0;
            this.databasePlugin = plugin;
            IDatabaseTab[] tabs = this.getTabs();
            for (int i = 0; i < this.elements.size(); ++i) {
                IGuiElement element = (IGuiElement)this.elements.get(i);
                if (!(element instanceof Tab)) continue;
                IDatabaseTab tab = tabs.length > i ? tabs[i] : null;
                Tab tabElement = (Tab)element;
                tabElement.setTab(tab);
            }
        }
    }

    private IDatabaseTab[] getTabs() {
        if (this.databasePlugin == null) {
            return new IDatabaseTab[]{AnalyzerTab.ANALYZE};
        }
        return this.databasePlugin.getTabs();
    }

    private class Tab
    extends GuiElement {
        private final int index;
        @Nullable
        public IDatabaseTab tab;
        private ItemStack displayStack;

        public Tab(int xPos, int yPos, int index) {
            super(xPos, yPos, 35, 26);
            this.displayStack = ItemStack.field_190927_a;
            this.index = index;
            this.addSelfEventHandler(GuiEvent.DownEvent.class, event -> {
                if (this.isVisible()) {
                    GeneticAnalyzerTabs.this.select(index);
                    SoundUtil.playButtonClick();
                    GeneticAnalyzerTabs.this.analyzer.update();
                }
            });
        }

        @Override
        public boolean canMouseOver() {
            return true;
        }

        @Override
        public boolean isVisible() {
            return this.tab != null;
        }

        public void setTab(@Nullable IDatabaseTab tab) {
            this.tab = tab;
            this.displayStack = tab != null ? tab.getIconStack() : ItemStack.field_190927_a;
        }

        @Override
        public void drawElement(int mouseX, int mouseY) {
            Drawable background;
            if (!this.isVisible()) {
                return;
            }
            int x = 0;
            Drawable drawable = background = GeneticAnalyzerTabs.this.selected == this.index ? SELECTED_BACKGROUND : UNSELECTED_BACKGROUND;
            if (GeneticAnalyzerTabs.this.selected != this.index) {
                x += 2;
            }
            background.draw(x, 0);
            if (!this.displayStack.func_190926_b()) {
                RenderHelper.func_74520_c();
                GlStateManager.func_179091_B();
                GuiUtil.drawItemStack(Minecraft.func_71410_x().field_71466_p, this.displayStack, x + 9, 5);
                RenderHelper.func_74518_a();
            }
        }
    }
}

