/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.BlockElevatorFrame;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorCaller;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockElevatorCaller
extends BlockPneumaticCraftCamo {
    BlockElevatorCaller() {
        super(Material.field_151573_f, "elevator_caller");
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityElevatorCaller.class;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityElevatorCaller) {
            int floor;
            TileEntityElevatorCaller teEC = (TileEntityElevatorCaller)te;
            if (!world.field_72995_K && (floor = this.getFloorForHit(teEC, side, hitX, hitY, hitZ)) >= 0) {
                BlockElevatorCaller.setSurroundingElevators(world, pos, floor);
            }
        }
        return this.getRotation(state).func_176734_d() == side;
    }

    private int getFloorForHit(TileEntityElevatorCaller teEC, EnumFacing side, float hitX, float hitY, float hitZ) {
        float x;
        switch (side) {
            case NORTH: {
                x = 1.0f - hitX;
                break;
            }
            case SOUTH: {
                x = hitX;
                break;
            }
            case EAST: {
                x = 1.0f - hitZ;
                break;
            }
            case WEST: {
                x = hitZ;
                break;
            }
            default: {
                return -1;
            }
        }
        float y = 1.0f - hitY;
        for (TileEntityElevatorCaller.ElevatorButton button : teEC.getFloors()) {
            if (!((double)x >= button.posX) || !((double)x <= button.posX + button.width) || !((double)y >= button.posY) || !((double)y <= button.posY + button.height)) continue;
            return button.floorNumber;
        }
        return -1;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d origin, Vec3d direction) {
        TileEntity te;
        this.setBlockBounds(field_185505_j);
        RayTraceResult rayTrace = super.func_180636_a(state, world, pos, origin, direction);
        EnumFacing orientation = this.getRotation((IBlockAccess)world, pos).func_176734_d();
        if (rayTrace != null && rayTrace.field_178784_b == orientation && (te = world.func_175625_s(pos)) instanceof TileEntityElevatorCaller) {
            TileEntityElevatorCaller caller = (TileEntityElevatorCaller)te;
            for (TileEntityElevatorCaller.ElevatorButton button : caller.getFloors()) {
                float startX = 0.0f;
                float startZ = 0.0f;
                float endX = 0.0f;
                float endZ = 0.0f;
                switch (orientation) {
                    case NORTH: {
                        startZ = 0.0f;
                        endZ = 0.01f;
                        endX = 1.0f - (float)button.posX;
                        startX = 1.0f - ((float)button.posX + (float)button.width);
                        break;
                    }
                    case SOUTH: {
                        startZ = 0.99f;
                        endZ = 1.0f;
                        startX = (float)button.posX;
                        endX = (float)button.posX + (float)button.width;
                        break;
                    }
                    case WEST: {
                        startX = 0.0f;
                        endX = 0.01f;
                        startZ = (float)button.posX;
                        endZ = (float)button.posX + (float)button.width;
                        break;
                    }
                    case EAST: {
                        startX = 0.99f;
                        endX = 1.0f;
                        endZ = 1.0f - (float)button.posX;
                        startZ = 1.0f - ((float)button.posX + (float)button.width);
                    }
                }
                this.setBlockBounds(new AxisAlignedBB((double)startX, (double)(1.0f - (float)(button.posY + button.height)), (double)startZ, (double)endX, (double)(1.0f - (float)button.posY), (double)endZ));
                RayTraceResult buttonTrace = super.func_180636_a(state, world, pos, origin, direction);
                if (buttonTrace == null) continue;
                if (startX > 0.01f && startX < 0.98f) {
                    startX += 0.01f;
                }
                if (startZ > 0.01f && startZ < 0.98f) {
                    startZ += 0.01f;
                }
                if (endX > 0.02f && endX < 0.99f) {
                    endX -= 0.01f;
                }
                if (endZ > 0.02f && endZ < 0.99f) {
                    endZ -= 0.01f;
                }
                this.setBlockBounds(new AxisAlignedBB((double)startX, (double)(1.01f - (float)(button.posY + button.height)), (double)startZ, (double)endX, (double)(0.99f - (float)button.posY), (double)endZ));
                buttonTrace.subHit = button.floorNumber;
                return buttonTrace;
            }
        }
        this.setBlockBounds(field_185505_j);
        return rayTrace;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        IBlockState camoState = this.getCamoState(worldIn, pos);
        return camoState != null ? camoState.func_193401_d(worldIn, pos, face) : BlockFaceShape.SOLID;
    }

    @Override
    protected boolean doesCamoOverrideBounds() {
        return false;
    }

    public static void setSurroundingElevators(World world, BlockPos pos, int floor) {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            TileEntityElevatorBase elevator = BlockElevatorCaller.getElevatorBase(world, pos.func_177972_a(dir).func_177967_a(EnumFacing.DOWN, 2));
            if (elevator == null) continue;
            elevator.goToFloor(floor);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.updateElevatorButtons(worldIn, pos);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.updateElevatorButtons(world, pos);
        super.func_180663_b(world, pos, state);
    }

    private void updateElevatorButtons(World world, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileEntityElevatorBase elevator;
            if (dir.func_176740_k() == EnumFacing.Axis.Y || (elevator = BlockElevatorCaller.getElevatorBase(world, pos.func_177972_a(dir).func_177967_a(EnumFacing.DOWN, 2))) == null) continue;
            elevator.updateFloors();
        }
    }

    private static TileEntityElevatorBase getElevatorBase(World world, BlockPos pos) {
        TileEntity te;
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntityElevatorBase elevator = null;
        if (block == Blockss.ELEVATOR_FRAME) {
            elevator = BlockElevatorFrame.getElevatorTE((IBlockAccess)world, pos);
        }
        if (block == Blockss.ELEVATOR_BASE && (te = world.func_175625_s(pos)) instanceof TileEntityElevatorBase && ((TileEntityElevatorBase)te).isCoreElevator()) {
            elevator = (TileEntityElevatorBase)te;
        }
        return elevator;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess par1IBlockAccess, BlockPos pos, EnumFacing side) {
        TileEntity te = par1IBlockAccess.func_175625_s(pos);
        if (te instanceof TileEntityElevatorCaller) {
            TileEntityElevatorCaller teEc = (TileEntityElevatorCaller)te;
            return teEc.getEmittingRedstone() ? 15 : 0;
        }
        return 0;
    }
}

