/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.common.block.BlockGasLift;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.block.tubes.ModuleRegistrator;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.ItemTubeModule;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAdvancedPressureTube;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPressureTube;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockPressureTube
extends BlockPneumaticCraftCamo {
    private static final AxisAlignedBB BASE_BOUNDS = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    private static final PropertyEnum<ConnectionType> UP = PropertyEnum.func_177709_a((String)"up", ConnectionType.class);
    private static final PropertyEnum<ConnectionType> DOWN = PropertyEnum.func_177709_a((String)"down", ConnectionType.class);
    private static final PropertyEnum<ConnectionType> NORTH = PropertyEnum.func_177709_a((String)"north", ConnectionType.class);
    private static final PropertyEnum<ConnectionType> EAST = PropertyEnum.func_177709_a((String)"east", ConnectionType.class);
    private static final PropertyEnum<ConnectionType> SOUTH = PropertyEnum.func_177709_a((String)"south", ConnectionType.class);
    private static final PropertyEnum<ConnectionType> WEST = PropertyEnum.func_177709_a((String)"west", ConnectionType.class);
    private static final PropertyEnum<ConnectionType>[] CONNECTION_PROPERTIES_3 = new PropertyEnum[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private final AxisAlignedBB[] boundingBoxes = new AxisAlignedBB[6];
    private final AxisAlignedBB[] closedBoundingBoxes = new AxisAlignedBB[6];
    private final Tier tier;

    public BlockPressureTube(String registryName, Tier tier) {
        super(Material.field_151573_f, registryName);
        double width = 0.125;
        double height = 0.375;
        this.boundingBoxes[0] = new AxisAlignedBB(0.5 - width, 0.375 - height, 0.5 - width, 0.5 + width, 0.375, 0.5 + width);
        this.boundingBoxes[1] = new AxisAlignedBB(0.5 - width, 0.625, 0.5 - width, 0.5 + width, 0.625 + height, 0.5 + width);
        this.boundingBoxes[2] = new AxisAlignedBB(0.5 - width, 0.5 - width, 0.375 - height, 0.5 + width, 0.5 + width, 0.375);
        this.boundingBoxes[3] = new AxisAlignedBB(0.5 - width, 0.5 - width, 0.625, 0.5 + width, 0.5 + width, 0.625 + height);
        this.boundingBoxes[4] = new AxisAlignedBB(0.375 - height, 0.5 - width, 0.5 - width, 0.375, 0.5 + width, 0.5 + width);
        this.boundingBoxes[5] = new AxisAlignedBB(0.625, 0.5 - width, 0.5 - width, 0.625 + height, 0.5 + width, 0.5 + width);
        height = 0.15625;
        this.closedBoundingBoxes[0] = new AxisAlignedBB(0.5 - width, 0.375 - height, 0.5 - width, 0.5 + width, 0.375, 0.5 + width);
        this.closedBoundingBoxes[1] = new AxisAlignedBB(0.5 - width, 0.625, 0.5 - width, 0.5 + width, 0.625 + height, 0.5 + width);
        this.closedBoundingBoxes[2] = new AxisAlignedBB(0.5 - width, 0.5 - width, 0.375 - height, 0.5 + width, 0.5 + width, 0.375);
        this.closedBoundingBoxes[3] = new AxisAlignedBB(0.5 - width, 0.5 - width, 0.625, 0.5 + width, 0.5 + width, 0.625 + height);
        this.closedBoundingBoxes[4] = new AxisAlignedBB(0.375 - height, 0.5 - width, 0.5 - width, 0.375, 0.5 + width, 0.5 + width);
        this.closedBoundingBoxes[5] = new AxisAlignedBB(0.625, 0.5 - width, 0.5 - width, 0.625 + height, 0.5 + width, 0.5 + width);
        this.tier = tier;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityPressureTube.class;
    }

    @Override
    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this.tier) {
            case ONE: {
                return new TileEntityPressureTube();
            }
            case TWO: {
                return new TileEntityAdvancedPressureTube();
            }
        }
        return null;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, (IProperty[])Arrays.copyOf(CONNECTION_PROPERTIES_3, CONNECTION_PROPERTIES_3.length), UNLISTED_CAMO_PROPERTIES);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        TileEntityPressureTube tube = BlockPressureTube.getTE(worldIn, pos);
        if (tube != null) {
            for (int i = 0; i < 6; ++i) {
                ConnectionType conn = tube.sidesClosed[i] ? ConnectionType.CLOSED : (tube.sidesConnected[i] ? ConnectionType.CONNECTED : ConnectionType.OPEN);
                state = state.func_177226_a(CONNECTION_PROPERTIES_3[i], (Comparable)((Object)conn));
            }
            if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockGasLift) {
                state = state.func_177226_a(CONNECTION_PROPERTIES_3[EnumFacing.UP.func_176745_a()], (Comparable)((Object)ConnectionType.CONNECTED));
            }
        }
        return state;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        if (this.tryPlaceModule(player, world, pos, side, hand, false)) {
            return true;
        }
        TubeModule module = BlockPressureTube.getLookedModule(world, pos, player);
        if (module != null) {
            return module.onActivated(player, hand);
        }
        return false;
    }

    public int getTier() {
        return this.tier.tier;
    }

    private static TileEntityPressureTube getTE(IBlockAccess world, BlockPos pos) {
        TileEntity te = PneumaticCraftUtils.getTileEntitySafely(world, pos);
        return te instanceof TileEntityPressureTube ? (TileEntityPressureTube)te : null;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        ModuleNetworkManager.getInstance(world).invalidateCache();
        TileEntityPressureTube te = BlockPressureTube.getTE((IBlockAccess)world, pos);
        if (te != null) {
            te.onNeighborTileUpdate();
        }
    }

    public boolean tryPlaceModule(EntityPlayer player, World world, BlockPos pos, EnumFacing side, EnumHand hand, boolean simulate) {
        TubeModule module;
        TileEntityPressureTube tePT = BlockPressureTube.getTE((IBlockAccess)world, pos);
        if (tePT == null) {
            return false;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() instanceof ItemTubeModule) {
            if (tePT.modules[side.ordinal()] == null && !tePT.sidesClosed[side.ordinal()]) {
                TubeModule module2 = ModuleRegistrator.getModule(((ItemTubeModule)heldStack.func_77973_b()).moduleName);
                if (module2 == null) {
                    return false;
                }
                if (simulate) {
                    module2.markFake();
                }
                tePT.setModule(module2, side);
                if (!simulate) {
                    this.func_189540_a(world.func_180495_p(pos), world, pos, this, pos.func_177972_a(side));
                    world.func_175685_c(pos, (Block)this, true);
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldStack.func_190918_g(1);
                    }
                    NetworkHandler.sendToAllAround(new PacketPlaySound(SoundType.field_185853_f.func_185844_d(), SoundCategory.BLOCKS, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), SoundType.field_185853_f.func_185843_a() * 5.0f, SoundType.field_185853_f.func_185847_b() * 0.9f, false), world);
                    ModuleNetworkManager.getInstance(world).invalidateCache();
                }
                return true;
            }
        } else if (heldStack.func_77973_b() == Itemss.ADVANCED_PCB && !simulate && (module = BlockPressureTube.getLookedModule(world, pos, player)) != null && !module.isUpgraded() && module.canUpgrade()) {
            if (!world.field_72995_K) {
                module.upgrade();
                tePT.sendDescriptionPacket();
                if (!player.field_71075_bZ.field_75098_d) {
                    heldStack.func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }

    public static TubeModule getLookedModule(World world, BlockPos pos, EntityPlayer player) {
        Pair<Vec3d, Vec3d> vecs = PneumaticCraftUtils.getStartAndEndLookVec((EntityLivingBase)player);
        IBlockState state = world.func_180495_p(pos);
        RayTraceResult rayTraceResult = state.func_185910_a(world, pos, (Vec3d)vecs.getLeft(), (Vec3d)vecs.getRight());
        TubeHitInfo tubeHitInfo = BlockPressureTube.getHitInfo(rayTraceResult);
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE) {
            TileEntityPressureTube tube = BlockPressureTube.getTE((IBlockAccess)world, pos);
            return tube == null ? null : tube.modules[tubeHitInfo.dir.ordinal()];
        }
        return null;
    }

    private static Pair<Boolean, EnumFacing> getLookedTube(World world, BlockPos pos, EntityPlayer player) {
        Pair<Vec3d, Vec3d> vecs = PneumaticCraftUtils.getStartAndEndLookVec((EntityLivingBase)player);
        IBlockState state = world.func_180495_p(pos);
        RayTraceResult rayTraceResult = state.func_185910_a(world, pos, (Vec3d)vecs.getLeft(), (Vec3d)vecs.getRight());
        TubeHitInfo tubeHitInfo = BlockPressureTube.getHitInfo(rayTraceResult);
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return tubeHitInfo.dir == null ? Pair.of((Object)true, (Object)rayTraceResult.field_178784_b) : Pair.of((Object)false, (Object)tubeHitInfo.dir);
        }
        return null;
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d origin, Vec3d direction) {
        TileEntityPressureTube tube;
        RayTraceResult bestRTR = null;
        AxisAlignedBB bestAABB = null;
        this.setBlockBounds(BASE_BOUNDS);
        RayTraceResult rtr = super.func_180636_a(state, world, pos, origin, direction);
        if (rtr != null) {
            rtr.hitInfo = TubeHitInfo.CENTER;
            bestRTR = rtr;
            bestAABB = this.func_185496_a(state, (IBlockAccess)world, pos);
        }
        if ((tube = BlockPressureTube.getTE((IBlockAccess)world, pos)) == null) {
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            if (!tube.sidesConnected[i] && !tube.sidesClosed[i]) continue;
            this.setBlockBounds(tube.sidesClosed[i] ? this.closedBoundingBoxes[i] : this.boundingBoxes[i]);
            rtr = super.func_180636_a(state, world, pos, origin, direction);
            if (!this.isCloserMOP(origin, bestRTR, rtr)) continue;
            rtr.hitInfo = new TubeHitInfo(EnumFacing.func_82600_a((int)i), TubeHitInfo.PartType.TUBE);
            bestRTR = rtr;
            bestAABB = this.func_185496_a(state, (IBlockAccess)world, pos);
        }
        TubeModule[] modules = tube.modules;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (modules[dir.ordinal()] == null) continue;
            this.setBlockBounds(modules[dir.ordinal()].boundingBoxes[dir.ordinal()]);
            rtr = super.func_180636_a(state, world, pos, origin, direction);
            if (!this.isCloserMOP(origin, bestRTR, rtr)) continue;
            rtr.hitInfo = new TubeHitInfo(dir, TubeHitInfo.PartType.MODULE);
            bestRTR = rtr;
            bestAABB = this.func_185496_a(state, (IBlockAccess)world, pos);
        }
        if (bestAABB != null) {
            this.setBlockBounds(bestAABB);
        }
        return bestRTR;
    }

    private boolean isCloserMOP(Vec3d origin, RayTraceResult originalMOP, RayTraceResult newMOP) {
        return newMOP != null && (originalMOP == null || origin.func_72436_e(newMOP.field_72307_f) < origin.func_72436_e(originalMOP.field_72307_f));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TubeModule module;
        TileEntityPressureTube tube;
        TubeHitInfo tubeHitInfo = BlockPressureTube.getHitInfo(target);
        if (tubeHitInfo.type == TubeHitInfo.PartType.TUBE) {
            return super.getPickBlock(state, target, world, pos, player);
        }
        if (tubeHitInfo.type == TubeHitInfo.PartType.MODULE && (tube = BlockPressureTube.getTE((IBlockAccess)world, pos)) != null && (module = tube.modules[tubeHitInfo.dir.ordinal()]) != null) {
            return new ItemStack(ModuleRegistrator.getModuleItem(module.getType()));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean rotateBlock(World world, EntityPlayer player, BlockPos pos, EnumFacing side, EnumHand hand) {
        if (player == null) {
            return false;
        }
        TileEntityPressureTube tube = BlockPressureTube.getTE((IBlockAccess)world, pos);
        if (tube == null) {
            return false;
        }
        TubeModule module = BlockPressureTube.getLookedModule(world, pos, player);
        if (player.func_70093_af()) {
            if (module != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    for (ItemStack drop : module.getDrops()) {
                        EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                        entity.func_92058_a(drop);
                        world.func_72838_d((Entity)entity);
                        entity.func_70100_b_(player);
                    }
                }
                tube.setModule(null, module.getDirection());
                this.func_189540_a(world.func_180495_p(pos), world, pos, this, pos.func_177972_a(side));
                world.func_175685_c(pos, (Block)this, true);
            } else {
                if (!player.field_71075_bZ.field_75098_d) {
                    this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
                }
                world.func_175698_g(pos);
            }
        } else if (module != null) {
            module.onActivated(player, hand);
        } else {
            Pair<Boolean, EnumFacing> lookData = BlockPressureTube.getLookedTube(world, pos, player);
            if (lookData != null) {
                EnumFacing sideHit = (EnumFacing)lookData.getRight();
                tube.sidesClosed[sideHit.ordinal()] = !tube.sidesClosed[sideHit.ordinal()];
                this.func_189540_a(world.func_180495_p(pos), world, pos, this, pos.func_177972_a(side));
                world.func_175685_c(pos, (Block)this, true);
            }
        }
        ModuleNetworkManager.getInstance(world).invalidateCache();
        return true;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        for (ItemStack drop : BlockPressureTube.getModuleDrops(BlockPressureTube.getTE((IBlockAccess)world, pos))) {
            EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            entity.func_92058_a(drop);
            world.func_72838_d((Entity)entity);
        }
        ModuleNetworkManager.getInstance(world).invalidateCache();
        super.func_180663_b(world, pos, state);
    }

    private static NonNullList<ItemStack> getModuleDrops(TileEntityPressureTube tube) {
        NonNullList drops = NonNullList.func_191196_a();
        if (tube != null) {
            for (TubeModule module : tube.modules) {
                if (module == null) continue;
                drops.addAll(module.getDrops());
            }
        }
        return drops;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (this.getCamoState((IBlockAccess)worldIn, pos) != null) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
            return;
        }
        BlockPressureTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_BOUNDS);
        TileEntityPressureTube tePt = BlockPressureTube.getTE((IBlockAccess)worldIn, pos);
        if (tePt != null) {
            for (int i = 0; i < 6; ++i) {
                if (tePt.sidesConnected[i]) {
                    BlockPressureTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.boundingBoxes[i]);
                }
                if (tePt.modules[i] == null) continue;
                BlockPressureTube.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)tePt.modules[i].boundingBoxes[i]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World par1World, BlockPos pos, Random par5Random) {
        if (!ConfigHandler.client.tubeModuleRedstoneParticles || PneumaticCraftRepressurized.proxy.particleLevel() == 2) {
            return;
        }
        TileEntityPressureTube tePt = BlockPressureTube.getTE((IBlockAccess)par1World, pos);
        if (tePt != null) {
            int l = 0;
            EnumFacing side = null;
            for (TubeModule module : tePt.modules) {
                if (module == null || module.getRedstoneLevel() <= l) continue;
                l = module.getRedstoneLevel();
                side = module.getDirection();
            }
            if (l > 0) {
                double d0 = (double)pos.func_177958_n() + 0.5 + (double)side.func_82601_c() * 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.5;
                double d1 = (double)pos.func_177956_o() + 0.5 + (double)side.func_96559_d() * 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.5;
                double d2 = (double)pos.func_177952_p() + 0.5 + (double)side.func_82599_e() * 0.5 + ((double)par5Random.nextFloat() - 0.5) * 0.5;
                float f = (float)l / 15.0f;
                float f1 = f * 0.6f + 0.4f;
                float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
                float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
                par1World.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, (double)f1, (double)f2, (double)f3, new int[0]);
            }
        }
    }

    public int func_180656_a(IBlockState state, IBlockAccess par1IBlockAccess, BlockPos pos, EnumFacing side) {
        TileEntityPressureTube tePt = BlockPressureTube.getTE(par1IBlockAccess, pos);
        if (tePt != null) {
            int redstoneLevel = 0;
            for (EnumFacing face : EnumFacing.field_82609_l) {
                if (tePt.modules[face.ordinal()] == null || side.func_176734_d() != face && (face == side || !tePt.modules[face.ordinal()].isInline())) continue;
                redstoneLevel = Math.max(redstoneLevel, tePt.modules[face.ordinal()].getRedstoneLevel());
            }
            return redstoneLevel;
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Nonnull
    private static TubeHitInfo getHitInfo(RayTraceResult result) {
        return result != null && result.hitInfo instanceof TubeHitInfo ? (TubeHitInfo)result.hitInfo : TubeHitInfo.NO_HIT;
    }

    public static enum ConnectionType implements IStringSerializable
    {
        OPEN("open"),
        CONNECTED("connected"),
        CLOSED("closed");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    private static class TubeHitInfo {
        static final TubeHitInfo NO_HIT = new TubeHitInfo(null, null);
        static final TubeHitInfo CENTER = new TubeHitInfo(null, PartType.TUBE);
        final EnumFacing dir;
        final PartType type;

        TubeHitInfo(EnumFacing dir, PartType type) {
            this.dir = dir;
            this.type = type;
        }

        static enum PartType {
            TUBE,
            MODULE;

        }
    }

    public static enum Tier {
        ONE(1, 5.0f, 7.0f, 1000),
        TWO(2, 20.0f, 25.0f, 4000);

        private final int tier;
        final float dangerPressure;
        final float criticalPressure;
        final int volume;

        private Tier(int tier, float dangerPressure, float criticalPressure, int volume) {
            this.tier = tier;
            this.dangerPressure = dangerPressure;
            this.criticalPressure = criticalPressure;
            this.volume = volume;
        }
    }
}

