/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import me.desht.pneumaticcraft.api.item.IPressurizable;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.model.module.ModelCharging;
import me.desht.pneumaticcraft.client.model.module.ModelModuleBase;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.util.TileEntityCache;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ModuleCharging
extends TubeModule {
    private TileEntityCache connectedInventory;

    @Override
    public String getType() {
        return "charging_module";
    }

    @Override
    protected GuiHandler.EnumGuiId getGuiId() {
        return null;
    }

    @Override
    public Class<? extends ModelModuleBase> getModelClass() {
        return ModelCharging.class;
    }

    @Override
    public void update() {
        super.update();
        if (this.pressureTube.world().field_72995_K || (this.pressureTube.world().func_82737_E() & 7L) != 0L) {
            return;
        }
        IItemHandler handler = this.getConnectedInventory();
        if (handler != null) {
            int airToTransfer = 80 * (this.upgraded ? 10 : 1);
            IAirHandler airHandler = this.pressureTube.getAirHandler(null);
            int airInTube = (int)(airHandler.getPressure() * (float)airHandler.getVolume());
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack chargedItem = handler.getStackInSlot(slot);
                if (!(chargedItem.func_77973_b() instanceof IPressurizable)) continue;
                IPressurizable chargingItem = (IPressurizable)chargedItem.func_77973_b();
                float itemPressure = chargingItem.getPressure(chargedItem);
                float itemVolume = chargingItem.getVolume(chargedItem);
                float delta = Math.abs(airHandler.getPressure() - itemPressure) / 2.0f;
                int airInItem = (int)(itemPressure * itemVolume);
                if (chargingItem.getPressure(chargedItem) > airHandler.getPressure() + 0.01f && chargingItem.getPressure(chargedItem) > 0.0f) {
                    int airToMove = Math.min(Math.min(airToTransfer, airInItem), (int)(delta * (float)airHandler.getVolume()));
                    chargingItem.addAir(chargedItem, -airToMove);
                    airHandler.addAir(airToMove);
                    airInTube += airToMove;
                    continue;
                }
                if (!(chargingItem.getPressure(chargedItem) < airHandler.getPressure() - 0.01f) || !(chargingItem.getPressure(chargedItem) < chargingItem.maxPressure(chargedItem))) continue;
                int maxAirInItem = (int)(chargingItem.maxPressure(chargedItem) * itemVolume);
                int airToMove = Math.min(Math.min(airToTransfer, airInTube), maxAirInItem - airInItem);
                airToMove = Math.min((int)(delta * itemVolume), airToMove);
                chargingItem.addAir(chargedItem, airToMove);
                airHandler.addAir(-airToMove);
            }
        }
    }

    @Override
    public void onNeighborTileUpdate() {
        this.connectedInventory = null;
    }

    private IItemHandler getConnectedInventory() {
        TileEntity te;
        if (this.connectedInventory == null) {
            this.connectedInventory = new TileEntityCache(this.pressureTube.world(), this.pressureTube.pos().func_177972_a(this.dir));
        }
        return (te = this.connectedInventory.getTileEntity()) != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.dir.func_176734_d()) ? (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.dir.func_176734_d()) : null;
    }
}

