/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat.behaviour;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.heat.HeatBehaviour;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourCustomTransition;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourFurnace;
import me.desht.pneumaticcraft.common.heat.behaviour.HeatBehaviourHeatFrame;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HeatBehaviourManager {
    private static final HeatBehaviourManager INSTANCE = new HeatBehaviourManager();
    private final Map<String, HeatBehaviour> behaviours = new HashMap<String, HeatBehaviour>();

    public static HeatBehaviourManager getInstance() {
        return INSTANCE;
    }

    public void onPostInit() {
        this.registerBehaviour(HeatBehaviourFurnace.class);
        this.registerBehaviour(HeatBehaviourHeatFrame.class);
        this.registerBehaviour(HeatBehaviourCustomTransition.class);
    }

    public void registerBehaviour(Class<? extends HeatBehaviour> behaviour) {
        if (behaviour == null) {
            throw new IllegalArgumentException("Can't register a null behaviour!");
        }
        try {
            HeatBehaviour ins = behaviour.newInstance();
            HeatBehaviour old = this.behaviours.put(ins.getId(), ins);
            if (old != null) {
                Log.warning("Registered a heat behaviour that has the same id as an already registered one. The old one will be discarded. Old behaviour class: " + old.getClass() + ". New class: " + behaviour.getClass());
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("The behaviour class doesn't have a nullary constructor, or is abstract! Class: " + behaviour);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Doesn't have access to the class (is it private?) Class: " + behaviour);
        }
    }

    HeatBehaviour getBehaviour(String id) {
        return this.behaviours.get(id);
    }

    public HeatBehaviour getNewBehaviourForId(String id) {
        HeatBehaviour behaviour = this.behaviours.get(id);
        if (behaviour != null) {
            try {
                return (HeatBehaviour)behaviour.getClass().newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Log.warning("No heat behaviour found for id: " + id);
        return null;
    }

    public void addHeatBehaviours(World world, BlockPos pos, EnumFacing direction, IHeatExchangerLogic logic, List<HeatBehaviour> list) {
        for (HeatBehaviour behaviour : this.behaviours.values()) {
            String id = behaviour.getId();
            behaviour.initialize(id, logic, world, pos, direction);
            if (!behaviour.isApplicable()) continue;
            try {
                behaviour = (HeatBehaviour)behaviour.getClass().newInstance();
                behaviour.initialize(id, logic, world, pos, direction);
                list.add(behaviour);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

