/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.recipes.AssemblyRecipe;
import me.desht.pneumaticcraft.common.recipes.programs.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyPlatform;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyRobot;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileEntityAssemblyDrill
extends TileEntityAssemblyRobot {
    @DescSynced
    private boolean isDrillOn;
    @DescSynced
    @LazySynced
    private float drillSpeed;
    public float drillRotation;
    public float oldDrillRotation;
    private int drillStep;

    @Override
    public void func_73660_a() {
        this.oldDrillRotation = this.drillRotation;
        super.func_73660_a();
        this.drillSpeed = this.isDrillOn ? Math.min(this.drillSpeed + 1.0f * this.speed, 100.0f) : Math.max(this.drillSpeed - 1.0f, 0.0f);
        this.drillRotation += this.drillSpeed;
        while (this.drillRotation >= 360.0f) {
            this.drillRotation -= 360.0f;
        }
        if (!this.func_145831_w().field_72995_K && this.drillStep > 0) {
            EnumFacing[] platformDirection = this.getPlatformDirection();
            if (platformDirection == null) {
                this.drillStep = 1;
            }
            switch (this.drillStep) {
                case 1: {
                    this.slowMode = false;
                    this.gotoHomePosition();
                    break;
                }
                case 2: {
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 3: {
                    this.isDrillOn = true;
                    break;
                }
                case 4: {
                    this.slowMode = true;
                    this.gotoNeighbour(platformDirection[0], platformDirection[1]);
                    break;
                }
                case 5: {
                    TileEntityAssemblyPlatform platform;
                    ItemStack output;
                    this.hoverOverNeighbour(platformDirection[0], platformDirection[1]);
                    this.isDrillOn = false;
                    TileEntity te = this.getTileEntityForCurrentDirection();
                    if (!(te instanceof TileEntityAssemblyPlatform) || (output = TileEntityAssemblyDrill.getDrilledOutputForItem((platform = (TileEntityAssemblyPlatform)te).getHeldStack())).func_190926_b()) break;
                    platform.setHeldStack(output);
                    break;
                }
                case 6: {
                    this.slowMode = false;
                    this.gotoHomePosition();
                }
            }
            if (this.isDoneInternal()) {
                ++this.drillStep;
                if (this.drillStep > 6) {
                    this.drillStep = 0;
                }
            }
        }
    }

    public void goDrilling() {
        if (this.drillStep == 0) {
            this.drillStep = 1;
            this.func_70296_d();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("drill", this.isDrillOn);
        tag.func_74776_a("drillSpeed", this.drillSpeed);
        tag.func_74768_a("drillStep", this.drillStep);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.isDrillOn = tag.func_74767_n("drill");
        this.drillSpeed = tag.func_74760_g("drillSpeed");
        this.drillStep = tag.func_74762_e("drillStep");
    }

    @Override
    public boolean isIdle() {
        return this.drillStep == 0 && this.isDoneInternal();
    }

    @Override
    public AssemblyProgram.EnumMachine getAssemblyType() {
        return AssemblyProgram.EnumMachine.DRILL;
    }

    private boolean isDoneInternal() {
        if (super.isDoneMoving()) {
            return this.isDrillOn ? this.drillSpeed > 99.0f : PneumaticCraftUtils.areFloatsEqual(this.drillSpeed, 0.0f);
        }
        return false;
    }

    @Override
    public boolean canMoveToDiagonalNeighbours() {
        return false;
    }

    private static ItemStack getDrilledOutputForItem(ItemStack input) {
        for (AssemblyRecipe recipe : AssemblyRecipe.drillRecipes) {
            if (!AssemblyProgram.isValidInput(recipe, input)) continue;
            return recipe.getOutput().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean reset() {
        if (this.isIdle()) {
            return true;
        }
        this.isDrillOn = false;
        this.drillStep = 6;
        return false;
    }
}

