/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api.module;

import javax.annotation.Nonnull;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.Constants;
import org.squiddev.plethora.api.module.AbstractModuleHandler;
import org.squiddev.plethora.gameplay.client.RenderHelpers;

public class BasicModuleHandler
extends AbstractModuleHandler
implements ICapabilityProvider {
    private final ResourceLocation id;
    private final Item item;
    @SideOnly(value=Side.CLIENT)
    private IBakedModel model;

    public BasicModuleHandler(ResourceLocation id, Item item) {
        this.id = id;
        this.item = item;
    }

    @Override
    @Nonnull
    public ResourceLocation getModule() {
        return this.id;
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(float delta) {
        Matrix4f matrix = new Matrix4f();
        matrix.setIdentity();
        matrix.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, delta));
        IBakedModel model = this.model;
        if (model == null) {
            model = this.model = RenderHelpers.getMesher().func_178089_a(new ItemStack(this.item));
        }
        return Pair.of((Object)model, (Object)matrix);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing enumFacing) {
        return capability == Constants.MODULE_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing enumFacing) {
        return (T)(capability == Constants.MODULE_HANDLER_CAPABILITY ? this : null);
    }
}

