/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.forestry;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.BeeDefinition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.math.Vec3i;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BasicMetaProvider;

@Injects(value="forestry")
public final class MetaGenome
extends BasicMetaProvider<IGenome> {
    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IGenome genome) {
        IChromosomeType[] types = genome.getSpeciesRoot().getKaryotype();
        HashMap<String, Object> active = new HashMap<String, Object>(types.length);
        HashMap<String, Object> inactive = new HashMap<String, Object>(types.length);
        for (IChromosomeType type : types) {
            active.put(type.getName(), MetaGenome.getAlleleMeta(genome.getActiveAllele(type)));
            inactive.put(type.getName(), MetaGenome.getAlleleMeta(genome.getInactiveAllele(type)));
        }
        HashMap<String, HashMap<String, Object>> out = new HashMap<String, HashMap<String, Object>>(2);
        out.put("active", active);
        out.put("inactive", inactive);
        return out;
    }

    public static Object getAlleleMeta(IAllele allele) {
        if (allele == null) {
            return null;
        }
        if (allele instanceof IAlleleArea) {
            Vec3i vec = ((IAlleleArea)allele).getValue();
            HashMap<String, Integer> out = new HashMap<String, Integer>();
            out.put("width", vec.func_177958_n());
            out.put("height", vec.func_177956_o());
            out.put("depth", vec.func_177952_p());
            return out;
        }
        if (allele instanceof IAlleleBoolean) {
            return ((IAlleleBoolean)allele).getValue();
        }
        if (allele instanceof IAlleleFloat) {
            return Float.valueOf(((IAlleleFloat)allele).getValue());
        }
        if (allele instanceof IAlleleFlowers) {
            return ((IAlleleFlowers)allele).getProvider().getFlowerType();
        }
        if (allele instanceof IAlleleInteger) {
            return ((IAlleleInteger)allele).getValue();
        }
        if (allele instanceof IAlleleSpecies) {
            IAlleleSpecies species = (IAlleleSpecies)allele;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("id", allele.getUID());
            data.put("displayName", allele.getAlleleName());
            data.put("authority", species.getAuthority());
            data.put("binomial", species.getBinomial());
            data.put("complexity", species.getComplexity());
            data.put("humidity", species.getHumidity().getName());
            data.put("temperature", species.getTemperature().getName());
            return data;
        }
        if (allele instanceof IAlleleTolerance) {
            return ((IAlleleTolerance)allele).getValue().toString().toLowerCase(Locale.ENGLISH);
        }
        return allele.getUID();
    }

    @Override
    @Nonnull
    public IGenome getExample() {
        return BeeDefinition.FOREST.getGenome();
    }
}

