/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.refinedstorage;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.integration.ItemFingerprint;
import org.squiddev.plethora.integration.refinedstorage.ItemIdentity;
import org.squiddev.plethora.integration.vanilla.NullableItemStack;
import org.squiddev.plethora.integration.vanilla.meta.MetaItemBasic;

public final class MethodsNetworkNode {
    private MethodsNetworkNode() {
    }

    @PlethoraMethod(modId="refinedstorage", doc="-- Get the energy usage of this RefinedStorage node")
    public static int getNodeEnergyUsage(@FromTarget INetworkNode node) {
        return node.getEnergyUsage();
    }

    @PlethoraMethod(modId="refinedstorage", doc="-- Get the energy usage of this RefinedStorage network")
    public static int getNetworkEnergyUsage(@FromTarget INetworkNode node) {
        INetwork network = node.getNetwork();
        return network != null ? network.getEnergyUsage() : node.getEnergyUsage();
    }

    @PlethoraMethod(modId="refinedstorage", doc="-- Get the energy stored usage in this RefinedStorage network")
    public static int getNetworkEnergyStored(@FromTarget INetworkNode node) {
        INetwork network = node.getNetwork();
        return network == null ? 0 : network.getEnergy().getStored();
    }

    @PlethoraMethod(modId="refinedstorage", doc="-- List all items which are stored in the network")
    public static Map<Integer, ?> listAvailableItems(IContext<INetworkNode> context) {
        INetwork network = ((INetworkNode)context.getTarget()).getNetwork();
        if (network == null) {
            return Collections.emptyMap();
        }
        Collection items = network.getItemStorageCache().getList().getStacks();
        HashMap<ItemIdentity, HashMap<String, Object>> seen = new HashMap<ItemIdentity, HashMap<String, Object>>();
        HashMap<Integer, HashMap<String, Object>> output = new HashMap<Integer, HashMap<String, Object>>(items.size());
        int i = 0;
        for (ItemStack stack : items) {
            HashMap<String, Object> basic = MetaItemBasic.getBasicMeta(stack);
            seen.put(new ItemIdentity(stack), basic);
            output.put(++i, basic);
        }
        for (ICraftingPattern pattern : network.getCraftingManager().getPatterns()) {
            for (ItemStack stack : pattern.getOutputs()) {
                if (stack == null || stack.func_190926_b()) continue;
                ItemIdentity key = new ItemIdentity(stack);
                HashMap<String, Object> basic = (HashMap<String, Object>)seen.get(key);
                if (basic == null) {
                    basic = MetaItemBasic.getBasicMeta(stack);
                    basic.put("count", 0);
                    output.put(++i, basic);
                }
                basic.put("isCraftable", true);
            }
        }
        return output;
    }

    @PlethoraMethod(modId="refinedstorage", doc="-- Search for an item in the network. You can specify the item as a string, with or without the damage value ('minecraft:stone' or 'minecraft:stone@0') or as a table with 'name', 'damage' and 'nbthash' fields. You must specify the 'name', but you can leave the other fields empty.")
    public static TypedLuaObject<NullableItemStack> findItem(IContext<INetworkNode> context, ItemFingerprint item) {
        INetwork network = ((INetworkNode)context.getTarget()).getNetwork();
        if (network == null) {
            return null;
        }
        for (ItemStack stack : network.getItemStorageCache().getList().getStacks()) {
            if (!item.matches(stack)) continue;
            return context.makeChildId(NullableItemStack.normal(stack)).getObject();
        }
        for (ICraftingPattern pattern : network.getCraftingManager().getPatterns()) {
            for (ItemStack stack : pattern.getOutputs()) {
                if (!item.matches(stack)) continue;
                return context.makeChildId(NullableItemStack.empty(stack)).getObject();
            }
        }
        return null;
    }

    @PlethoraMethod(modId="refinedstorage", doc="-- Search all items in the network. You can specify the item as a string, with or without the damage value ('minecraft:stone' or 'minecraft:stone@0') or as a table with 'name', 'damage' and 'nbthash' fields. You must specify the 'name', but you can leave the other fields empty.")
    public static Map<Integer, TypedLuaObject<NullableItemStack>> findItems(IContext<INetworkNode> context, ItemFingerprint item) {
        INetwork network = ((INetworkNode)context.getTarget()).getNetwork();
        if (network == null) {
            return Collections.emptyMap();
        }
        HashSet<ItemIdentity> seen = new HashSet<ItemIdentity>();
        int i = 0;
        HashMap<Integer, TypedLuaObject<NullableItemStack>> out = new HashMap<Integer, TypedLuaObject<NullableItemStack>>();
        for (ItemStack stack : network.getItemStorageCache().getList().getStacks()) {
            if (!item.matches(stack)) continue;
            seen.add(new ItemIdentity(stack));
            out.put(++i, context.makeChildId(NullableItemStack.normal(stack)).getObject());
        }
        for (ICraftingPattern pattern : network.getCraftingManager().getPatterns()) {
            for (ItemStack stack : pattern.getOutputs()) {
                if (stack == null || !item.matches(stack) || !seen.add(new ItemIdentity(stack))) continue;
                out.put(++i, context.makeChildId(NullableItemStack.empty(stack)).getObject());
            }
        }
        return out;
    }

    @PlethoraMethod(modId="refinedstorage", doc="-- List all crafting tasks in the network")
    public static Map<Integer, Object> getCraftingTasks(IContext<INetworkNode> context) {
        INetwork network = ((INetworkNode)context.getTarget()).getNetwork();
        if (network == null) {
            return Collections.emptyMap();
        }
        Collection tasks = network.getCraftingManager().getTasks();
        int i = 0;
        HashMap<Integer, Object> output = new HashMap<Integer, Object>(tasks.size());
        for (ICraftingTask task : tasks) {
            output.put(++i, context.makeChildId(task).getObject());
        }
        return output;
    }
}

