/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.ArgumentHelper;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.api.reference.ItemSlot;
import org.squiddev.plethora.integration.vanilla.meta.MetaItemBasic;

public final class MethodsInventory {
    private MethodsInventory() {
    }

    @PlethoraMethod(doc="-- List all items in this inventory")
    public static Map<Integer, Object> list(@Nonnull @FromTarget IItemHandler inventory) {
        HashMap<Integer, Object> items = new HashMap<Integer, Object>();
        int size = inventory.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            items.put(i + 1, MetaItemBasic.getBasicMeta(stack));
        }
        return items;
    }

    @Optional
    @PlethoraMethod(doc="-- The item in the specified slot. The slot number starts from 1.")
    public static TypedLuaObject<ItemSlot> getItem(IContext<IItemHandler> baked, int slot) throws LuaException {
        IItemHandler inventory = (IItemHandler)baked.getTarget();
        ArgumentHelper.assertBetween(slot, 1, inventory.getSlots(), "Slot out of range (%s)");
        ItemStack stack = inventory.getStackInSlot(slot - 1);
        return stack.func_190926_b() ? null : baked.makeChildId(new ItemSlot(inventory, slot - 1)).getObject();
    }

    @PlethoraMethod(doc="-- The size of the inventory")
    public static int size(@FromTarget IItemHandler inventory) {
        return inventory.getSlots();
    }

    @Optional
    @PlethoraMethod(doc="-- The metadata of the item in the specified slot. The slot number starts from 1.")
    public static TypedMeta<ItemStack, ?> getItemMeta(IContext<IItemHandler> context, int slot) throws LuaException {
        IItemHandler inventory = (IItemHandler)context.getTarget();
        ArgumentHelper.assertBetween(slot, 1, inventory.getSlots(), "Slot out of range (%s)");
        ItemStack stack = inventory.getStackInSlot(slot - 1);
        return stack.func_190926_b() ? null : context.makePartialChild(stack).getMeta();
    }
}

