/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.method;

import dan200.computercraft.api.lua.LuaException;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.FromSubtarget;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.gameplay.PlethoraFakePlayer;
import org.squiddev.plethora.integration.PlayerInteractionHelpers;
import org.squiddev.plethora.integration.vanilla.FakePlayerProviderEntity;
import org.squiddev.plethora.utils.PlayerHelpers;

public final class MethodsKineticActions {
    private MethodsKineticActions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PlethoraMethod(module={"plethora:kinetic"}, doc="function([duration:integer], [hand:string]):boolean, string|nil -- Right click with this item using a particular hand (\"left\" or \"right\"). The duration is in ticks, or 1/20th of a second.")
    public static MethodResult use(@FromSubtarget(value={"origin"}) EntityLivingBase entity, @Optional @FromContext(value={"origin"}) IPlayerOwnable ownable, @Optional(defInt=0) int duration, @Optional String hand) throws LuaException {
        PlethoraFakePlayer fakePlayer;
        Object player;
        EnumHand handE;
        if (duration < 0) {
            throw new LuaException("Duration out of range (must be >= 0)");
        }
        switch (hand = hand == null ? "main" : hand.toLowerCase(Locale.ENGLISH)) {
            case "main": 
            case "mainhand": {
                handE = EnumHand.MAIN_HAND;
                break;
            }
            case "off": 
            case "offhand": {
                handE = EnumHand.OFF_HAND;
                break;
            }
            default: {
                throw new LuaException("Unknown hand '" + hand + "', expected 'main' or 'off'");
            }
        }
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            fakePlayer = null;
        } else {
            if (entity instanceof EntityPlayer) {
                throw new LuaException("An unexpected player was used");
            }
            fakePlayer = FakePlayerProviderEntity.getPlayer((Entity)entity, ownable);
            player = fakePlayer;
        }
        if (fakePlayer != null) {
            FakePlayerProviderEntity.load(fakePlayer, (Entity)entity);
        }
        try {
            RayTraceResult hit = PlayerHelpers.findHit(player, entity);
            MethodResult methodResult = PlayerInteractionHelpers.use(player, hit, handE, duration);
            return methodResult;
        }
        finally {
            if (fakePlayer != null) {
                FakePlayerProviderEntity.unload(fakePlayer, entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PlethoraMethod(module={"plethora:kinetic"}, doc="function():boolean, string|nil -- Left click with this item. Returns the action taken.")
    public static Object[] swing(@FromSubtarget(value={"origin"}) EntityLivingBase entity, @Optional @FromContext(value={"origin"}) IPlayerOwnable ownable) throws LuaException {
        PlethoraFakePlayer fakePlayer;
        Object player;
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            fakePlayer = null;
        } else {
            if (entity instanceof EntityPlayer) {
                throw new LuaException("An unexpected player was used");
            }
            fakePlayer = FakePlayerProviderEntity.getPlayer((Entity)entity, ownable);
            player = fakePlayer;
        }
        if (fakePlayer != null) {
            FakePlayerProviderEntity.load(fakePlayer, (Entity)entity);
        }
        try {
            RayTraceResult hit = PlayerHelpers.findHit(player, entity);
            switch (hit.field_72313_a) {
                case ENTITY: {
                    Pair<Boolean, String> result = PlayerInteractionHelpers.attack(player, hit.field_72308_g);
                    Object[] objectArray = new Object[]{result.getLeft(), result.getRight()};
                    return objectArray;
                }
                case BLOCK: {
                    if (fakePlayer != null) {
                        Pair<Boolean, String> result = fakePlayer.dig(hit.func_178782_a(), hit.field_178784_b);
                        Object[] objectArray = new Object[]{result.getLeft(), result.getRight()};
                        return objectArray;
                    }
                    Object[] objectArray = new Object[]{false, "Nothing to do here"};
                    return objectArray;
                }
            }
            Object[] objectArray = new Object[]{false, "Nothing to do here"};
            return objectArray;
        }
        finally {
            player.func_184602_cy();
            if (fakePlayer != null) {
                FakePlayerProviderEntity.unload(fakePlayer, entity);
                fakePlayer.updateCooldown();
            }
        }
    }
}

