/*
 * Decompiled with CFR 0.152.
 */
package ninja.leaping.configurate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import ninja.leaping.configurate.ConfigValue;
import ninja.leaping.configurate.SimpleConfigurationNode;
import ninja.leaping.configurate.ValueType;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class ScalarConfigValue
extends ConfigValue {
    private volatile Object value;

    ScalarConfigValue(SimpleConfigurationNode holder) {
        super(holder);
    }

    @Override
    ValueType getType() {
        return ValueType.SCALAR;
    }

    @Override
    public @Nullable Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(@Nullable Object value) {
        Preconditions.checkNotNull((Object)value);
        if (!this.holder.getOptions().acceptsType(value.getClass())) {
            throw new IllegalArgumentException("Configuration does not accept objects of type " + value.getClass());
        }
        this.value = value;
    }

    @Override
    @Nullable SimpleConfigurationNode putChild(@NonNull Object key, @Nullable SimpleConfigurationNode value) {
        return null;
    }

    @Override
    @Nullable SimpleConfigurationNode putChildIfAbsent(@NonNull Object key, @Nullable SimpleConfigurationNode value) {
        return null;
    }

    @Override
    public @Nullable SimpleConfigurationNode getChild(@Nullable Object key) {
        return null;
    }

    @Override
    public @NonNull Iterable<SimpleConfigurationNode> iterateChildren() {
        return Collections.emptySet();
    }

    @Override
    @NonNull ScalarConfigValue copy(@NonNull SimpleConfigurationNode holder) {
        ScalarConfigValue copy = new ScalarConfigValue(holder);
        copy.value = this.value;
        return copy;
    }

    @Override
    public void clear() {
        this.value = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScalarConfigValue that = (ScalarConfigValue)o;
        return Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public String toString() {
        return "ScalarConfigValue{value=" + this.value + '}';
    }
}

