/*
 * Decompiled with CFR 0.152.
 */
package net.ellertonCMMShade.japng.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.ellertonCMMShade.japng.PngChunkCode;
import net.ellertonCMMShade.japng.chunks.PngAnimationControl;
import net.ellertonCMMShade.japng.chunks.PngFrameControl;
import net.ellertonCMMShade.japng.chunks.PngGamma;
import net.ellertonCMMShade.japng.chunks.PngHeader;
import net.ellertonCMMShade.japng.chunks.PngPalette;
import net.ellertonCMMShade.japng.error.PngException;
import net.ellertonCMMShade.japng.map.PngChunkMap;
import net.ellertonCMMShade.japng.reader.PngChunkProcessor;
import net.ellertonCMMShade.japng.util.PngContainer;

public abstract class PngContainerProcessor<ResultT>
implements PngChunkProcessor<ResultT> {
    protected final PngContainer container = new PngContainer();

    @Override
    public void processHeader(PngHeader header) throws PngException {
        this.container.header = header;
    }

    @Override
    public void processGamma(PngGamma pngGamma) {
        this.container.gamma = pngGamma;
    }

    @Override
    public void processPalette(byte[] bytes, int position, int length) throws PngException {
        this.container.palette = PngPalette.from(bytes, position, length);
    }

    @Override
    public void processTransparency(byte[] bytes, int position, int length) throws PngException {
    }

    @Override
    public void processAnimationControl(PngAnimationControl animationControl) {
        this.container.animationControl = animationControl;
        this.container.animationFrames = new ArrayList<PngFrameControl>(this.container.animationControl.numFrames);
    }

    @Override
    public void processFrameControl(PngFrameControl pngFrameControl) throws PngException {
        this.container.animationFrames.add(pngFrameControl);
        this.container.currentFrame = pngFrameControl;
    }

    @Override
    public void processDefaultImageData(InputStream inputStream, PngChunkCode code, int position, int length) throws IOException, PngException {
        if (null != this.container.currentFrame) {
            throw new IllegalStateException("Attempt to process main frame image data but an animation frame is in place");
        }
        this.container.hasDefaultImage = true;
        this.processImageDataStream(inputStream);
    }

    @Override
    public void processFrameImageData(InputStream inputStream, PngChunkCode code, int position, int length) throws IOException, PngException {
        if (null == this.container.currentFrame) {
            throw new IllegalStateException("Attempt to process animation frame image data without a frame in place");
        }
        this.container.currentFrame.appendImageData(new PngChunkMap(code, position, length, 0));
        this.processImageDataStream(inputStream);
    }

    protected void processImageDataStream(InputStream inputStream) throws IOException, PngException {
        inputStream.skip(inputStream.available());
    }

    @Override
    public void processChunkMapItem(PngChunkMap pngChunkMap) {
        this.container.chunks.add(pngChunkMap);
    }

    public PngContainer getContainer() {
        return this.container;
    }
}

