/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.insolator;

import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiInsolator;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.machine.BaseRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.insolator.InsolatorRecipeCategoryTree;
import cofh.thermalexpansion.plugins.jei.machine.insolator.InsolatorRecipeWrapper;
import cofh.thermalexpansion.util.managers.machine.InsolatorManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class InsolatorRecipeCategory
extends BaseRecipeCategory<InsolatorRecipeWrapper> {
    public static boolean enable = true;
    protected IDrawableStatic progress;
    protected IDrawableStatic speed;
    protected IDrawableStatic tank;
    protected IDrawableStatic tankOverlay;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Machine.Insolator", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new InsolatorRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new InsolatorRecipeCategoryTree(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(InsolatorRecipeCategory.getRecipes(guiHelper), "thermalexpansion.insolator");
        registry.addRecipeClickArea(GuiInsolator.class, 79, 34, 24, 16, new String[]{"thermalexpansion.insolator", "thermalexpansion.insolator_tree"});
        registry.addRecipeCatalyst((Object)BlockMachine.machineInsolator, new String[]{"thermalexpansion.insolator"});
        InsolatorRecipeCategoryTree.initialize(registry);
    }

    public static List<InsolatorRecipeWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<InsolatorRecipeWrapper> recipes = new ArrayList<InsolatorRecipeWrapper>();
        for (InsolatorManager.InsolatorRecipe recipe : InsolatorManager.getRecipeList()) {
            if (recipe.getType() != InsolatorManager.Type.STANDARD) continue;
            recipes.add(new InsolatorRecipeWrapper(guiHelper, recipe));
        }
        return recipes;
    }

    public InsolatorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiInsolator.TEXTURE, 26, 11, 124, 62, 0, 0, 16, 24);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.machine.insolator.name");
        this.progress = Drawables.getDrawables(guiHelper).getProgress(0);
        this.speed = Drawables.getDrawables(guiHelper).getScale(9);
        this.tank = Drawables.getDrawables(guiHelper).getTank(0);
        this.tankOverlay = Drawables.getDrawables(guiHelper).getTankSmallOverlay(0);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.insolator";
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        this.progress.draw(minecraft, 69, 23);
        this.speed.draw(minecraft, 34, 33);
        this.tank.draw(minecraft, 140, 0);
        this.energyMeter.draw(minecraft, 2, 8);
    }

    public void setRecipe(IRecipeLayout recipeLayout, InsolatorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List inputFluids = ingredients.getInputs(FluidStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        guiItemStacks.init(0, true, 21, 14);
        guiItemStacks.init(1, true, 45, 14);
        guiItemStacks.init(2, false, 105, 14);
        guiFluidStacks.init(0, true, 141, 1, 16, 60, 10000, false, (IDrawable)this.tankOverlay);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)inputs.get(1));
        guiItemStacks.set(2, (List)outputs.get(0));
        guiFluidStacks.set(0, (List)inputFluids.get(0));
        if (outputs.size() > 1) {
            guiItemStacks.init(3, false, 105, 41);
            guiItemStacks.set(3, (List)outputs.get(1));
            guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
                if (slotIndex == 3) {
                    tooltip.add(StringHelper.localize((String)"info.cofh.chance") + ": " + recipeWrapper.chance + "%");
                }
            });
        }
        guiFluidStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> tooltip.add("\u00a79" + StringHelper.localize((String)"info.cofh.input")));
    }
}

