/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import openblocks.OpenBlocks;
import openblocks.common.item.ItemGlyph;
import openmods.model.BakedModelAdapter;
import openmods.model.ModelUpdater;
import openmods.utils.CollectionUtils;

public class ModelGlyph
implements IModel {
    public final Optional<ResourceLocation> baseModel;
    public final Optional<ResourceLocation> fontTexture;
    private static final ResourceLocation DEFAULT_FONT = new ResourceLocation("minecraft", "font/ascii");
    private static final ResourceLocation DYNAMIC_GLYPH_TEXTURE = OpenBlocks.location("dynamic_glyph");
    public static final IModel INSTANCE = new ModelGlyph(Optional.empty(), Optional.empty());

    private ModelGlyph(Optional<ResourceLocation> baseModel, Optional<ResourceLocation> fontTexture) {
        this.baseModel = baseModel;
        this.fontTexture = fontTexture;
    }

    public Collection<ResourceLocation> getTextures() {
        return CollectionUtils.asSet(this.fontTexture);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        if (this.baseModel.isPresent()) {
            ResourceLocation baseModelLocation = this.baseModel.get();
            IModel templateModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)baseModelLocation, (String)("Couldn't load dependency: " + baseModelLocation));
            TextureAtlasSprite font = bakedTextureGetter.apply(this.fontTexture.orElse(DEFAULT_FONT));
            BakedModel[] overrides = new BakedModel[ItemGlyph.ALMOST_ASCII.length];
            ModelOverride override = new ModelOverride(overrides);
            ModelStateComposition templateModelState = new ModelStateComposition(state, templateModel.getDefaultState());
            ImmutableMap transforms = PerspectiveMapWrapper.getTransforms((IModelState)templateModelState);
            for (int i = 0; i < ItemGlyph.ALMOST_ASCII.length; ++i) {
                char ch = ItemGlyph.ALMOST_ASCII[i];
                if (ItemGlyph.isHiddenCharacter(ch)) continue;
                ClippedFontSprite glyphIcon = new ClippedFontSprite(font, i);
                Function<ResourceLocation, TextureAtlasSprite> patchedTextureGetter = location -> DYNAMIC_GLYPH_TEXTURE.equals(location) ? glyphIcon : (TextureAtlasSprite)bakedTextureGetter.apply((ResourceLocation)location);
                IBakedModel bakedCharModel = templateModel.bake((IModelState)templateModelState, format, patchedTextureGetter);
                overrides[i] = new BakedModel(override, bakedCharModel, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transforms);
            }
            return overrides[ItemGlyph.DEFAULT_CHAR_INDEX];
        }
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return missing.bake(missing.getDefaultState(), format, bakedTextureGetter);
    }

    public IModel process(ImmutableMap<String, String> customData) {
        ModelUpdater updater = new ModelUpdater(customData);
        Optional baseModel = updater.get("base", ModelUpdater.MODEL_LOCATION, this.baseModel);
        return updater.hasChanged() ? new ModelGlyph(baseModel, this.fontTexture) : this;
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        Optional<ResourceLocation> fontTexture = ModelGlyph.tryReplaceTexture((String)textures.get((Object)"font"), this.fontTexture);
        return fontTexture.equals(this.fontTexture) ? this : new ModelGlyph(this.baseModel, this.fontTexture);
    }

    private static Optional<ResourceLocation> tryReplaceTexture(String newTexture, Optional<ResourceLocation> currentTexture) {
        if (newTexture == null) {
            return currentTexture;
        }
        if (newTexture.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ResourceLocation(newTexture));
    }

    private static class ClippedFontSprite
    extends TextureAtlasSprite {
        private final TextureAtlasSprite parent;
        private final int row;
        private final int column;
        private final float minU;
        private final float maxU;
        private final float minV;
        private final float maxV;

        protected ClippedFontSprite(TextureAtlasSprite parent, int index) {
            super(OpenBlocks.location("dynamic_glyph_" + index).toString());
            this.parent = parent;
            this.field_130223_c = parent.func_94211_a() / 16;
            this.field_130224_d = parent.func_94216_b() / 16;
            this.column = index % 16;
            this.row = index / 16;
            this.field_110975_c = parent.func_130010_a() + this.column * this.field_130223_c;
            this.field_110974_d = parent.func_110967_i() + this.row * this.field_130224_d;
            float du = parent.func_94212_f() - parent.func_94209_e();
            float dv = parent.func_94210_h() - parent.func_94206_g();
            float pu = (float)this.column / 16.0f;
            float pv = (float)this.row / 16.0f;
            float npu = (float)(this.column + 1) / 16.0f;
            float npv = (float)(this.row + 1) / 16.0f;
            this.minU = parent.func_94209_e() + du * pu;
            this.minV = parent.func_94206_g() + dv * pv;
            this.maxU = parent.func_94209_e() + du * npu;
            this.maxV = parent.func_94206_g() + dv * npv;
        }

        public int func_110970_k() {
            return 1;
        }

        public int[][] func_147965_a(int index) {
            if (this.field_110976_a.isEmpty()) {
                this.populateTextureData();
            }
            return super.func_147965_a(index);
        }

        private void populateTextureData() {
            int[][] fullParentData = this.parent.func_147965_a(0);
            int[] parentData = fullParentData[0];
            int mipmapDepth = fullParentData.length;
            int[] textureData = new int[this.field_130223_c * this.field_130224_d];
            int parentWidth = this.parent.func_94211_a();
            int si = this.row * this.field_130224_d * parentWidth + this.column * this.field_130223_c;
            int di = 0;
            for (int y = 0; y < this.field_130224_d; ++y) {
                System.arraycopy(parentData, si, textureData, di, this.field_130223_c);
                si += parentWidth;
                di += this.field_130223_c;
            }
            int[][] fullTextureData = new int[mipmapDepth][];
            fullTextureData[0] = textureData;
            this.func_110968_a(Lists.newArrayList((Object[])new int[][][]{fullTextureData}));
            this.func_147963_d(mipmapDepth - 1);
        }

        public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
            return true;
        }

        public boolean func_130098_m() {
            return false;
        }

        public float func_94209_e() {
            return this.minU;
        }

        public float func_94212_f() {
            return this.maxU;
        }

        public float func_94206_g() {
            return this.minV;
        }

        public float func_94210_h() {
            return this.maxV;
        }

        public float func_94214_a(double u) {
            float f = this.maxU - this.minU;
            return this.minU + f * (float)u / 16.0f;
        }

        public float func_188537_a(float u) {
            float f = this.maxU - this.minU;
            return (u - this.minU) / f * 16.0f;
        }

        public float func_94207_b(double v) {
            float f = this.maxV - this.minV;
            return this.minV + f * (float)v / 16.0f;
        }

        public float func_188536_b(float v) {
            float f = this.maxV - this.minV;
            return (v - this.minV) / f * 16.0f;
        }

        public void func_110966_b(int newWidth) {
        }

        public void func_110969_c(int newHeight) {
        }
    }

    private static class BakedModel
    extends BakedModelAdapter {
        private final ItemOverrideList override;

        public BakedModel(ItemOverrideList override, IBakedModel base, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> cameraTransforms) {
            super(base, cameraTransforms);
            this.override = override;
        }

        public ItemOverrideList func_188617_f() {
            return this.override;
        }

        public IBakedModel getOriginalModel() {
            return this.base;
        }
    }

    private static class ModelOverride
    extends ItemOverrideList {
        private final BakedModel[] charModels;

        public ModelOverride(BakedModel[] charModels) {
            super(Collections.emptyList());
            this.charModels = charModels;
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            IBakedModel model = this.getModel(stack).getOriginalModel();
            return model.func_188617_f().handleItemState(model, stack, world, entity);
        }

        private BakedModel getModel(ItemStack stack) {
            BakedModel result;
            int charIndex = ItemGlyph.getCharIndex(stack);
            if (charIndex >= charIndex && charIndex < this.charModels.length && (result = this.charModels[charIndex]) != null) {
                return result;
            }
            return this.charModels[ItemGlyph.DEFAULT_CHAR_INDEX];
        }
    }
}

