/*
 * Decompiled with CFR 0.152.
 */
package nc.item.energy;

import gregtech.api.capability.GregtechCapabilities;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.item.energy.ItemEnergyWrapper;
import nc.item.energy.ItemEnergyWrapperGT;
import nc.tile.internal.energy.EnergyStorage;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;

public class ItemEnergyCapabilityProvider
implements ICapabilityProvider {
    private ItemStack stack;
    private EnergyStorage storage;
    private ItemEnergyWrapper wrapper;
    private ItemEnergyWrapperGT wrapperGT;
    private final int energyTier;

    public ItemEnergyCapabilityProvider(ItemStack stack, NBTTagCompound nbt, int energyTier) {
        this(stack, nbt.func_74762_e("energy"), nbt.func_74762_e("capacity"), nbt.func_74762_e("maxTransfer"), energyTier);
    }

    public ItemEnergyCapabilityProvider(final ItemStack stack, int energy, int capacity, int maxTransfer, int energyTier) {
        this.stack = stack;
        this.storage = new EnergyStorage(capacity, maxTransfer, energy){

            @Override
            public int getEnergyStored() {
                if (stack.func_77942_o()) {
                    return stack.func_77978_p().func_74762_e("energy");
                }
                return 0;
            }

            @Override
            public int getMaxEnergyStored() {
                if (stack.func_77942_o()) {
                    return stack.func_77978_p().func_74762_e("capacity");
                }
                return 0;
            }

            @Override
            public void setEnergyStored(int energy) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("energy", energy);
            }

            @Override
            public void changeEnergyStored(int energy) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("energy", MathHelper.func_76125_a((int)(stack.func_77978_p().func_74762_e("energy") + energy / stack.func_190916_E()), (int)0, (int)this.getMaxEnergyStored()));
            }

            @Override
            public void setStorageCapacity(int capacity) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("capacity", capacity);
            }

            @Override
            public boolean canReceive() {
                if (stack.func_77942_o()) {
                    return stack.func_77978_p().func_74762_e("maxTransfer") > 0;
                }
                return super.canReceive();
            }

            @Override
            public boolean canExtract() {
                if (stack.func_77942_o()) {
                    return stack.func_77978_p().func_74762_e("maxTransfer") > 0;
                }
                return super.canExtract();
            }

            @Override
            public int getMaxTransfer() {
                if (stack.func_77942_o()) {
                    return stack.func_77978_p().func_74762_e("maxTransfer");
                }
                return 0;
            }

            @Override
            public void setMaxTransfer(int maxTransfer) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                stack.func_77978_p().func_74768_a("maxTransfer", maxTransfer);
            }

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                if (!this.canReceive()) {
                    return 0;
                }
                int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxTransfer(), maxReceive));
                if (!simulate) {
                    stack.func_77978_p().func_74768_a("energy", this.getEnergyStored() + energyReceived / stack.func_190916_E());
                }
                return energyReceived;
            }

            @Override
            public int extractEnergy(int maxExtract, boolean simulate) {
                if (!this.canExtract()) {
                    return 0;
                }
                int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.getMaxTransfer(), maxExtract));
                if (!simulate) {
                    stack.func_77978_p().func_74768_a("energy", this.getEnergyStored() - energyExtracted / stack.func_190916_E());
                }
                return energyExtracted;
            }
        };
        this.energyTier = energyTier;
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.wrapper == null) {
                this.wrapper = new ItemEnergyWrapper(this.storage);
            }
            return (T)this.wrapper;
        }
        if (ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM) {
            if (this.wrapperGT == null) {
                this.wrapperGT = new ItemEnergyWrapperGT(this.stack, this.storage, this.energyTier);
            }
            return (T)this.wrapperGT;
        }
        return null;
    }
}

