/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import io.netty.buffer.ByteBuf;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockParaChest;
import micdoodle8.mods.galacticraft.core.entities.IScaleableFuelLevel;
import micdoodle8.mods.galacticraft.core.inventory.ContainerParaChest;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.network.PacketDynamicInventory;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityParaChest
extends TileEntityAdvanced
implements IInventorySettable,
IScaleableFuelLevel {
    private final int tankCapacity = 5000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public boolean adjacentChestChecked = false;
    public float lidAngle;
    public float prevLidAngle;
    public int numUsingPlayers;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public EnumDyeColor color = EnumDyeColor.RED;

    public TileEntityParaChest() {
        super("container.parachest.name");
        this.inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamicInventory(this));
        }
    }

    @Override
    public int getScaledFuelLevel(int i) {
        double fuelLevel = this.fuelTank.getFluid() == null ? 0.0 : (double)this.fuelTank.getFluid().amount;
        return (int)(fuelLevel * (double)i / (double)this.tankCapacity);
    }

    @Override
    public void setSizeInventory(int size) {
        this.inventory = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    protected boolean handleInventory() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int size = nbt.func_74762_e("chestContentLength");
        if ((size - 3) % 18 != 0) {
            size += 18 - (size - 3) % 18;
        }
        this.inventory = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.getInventory());
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (nbt.func_74764_b("color")) {
            this.color = EnumDyeColor.func_176766_a((int)nbt.func_74762_e("color"));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("chestContentLength", this.getInventory().size());
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.getInventory());
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74768_a("color", this.color.func_176767_b());
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.adjacentChestChecked = false;
    }

    @Override
    public void func_73660_a() {
        float f;
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.numUsingPlayers != 0 && (this.ticks + this.func_174877_v().func_177958_n() + this.func_174877_v().func_177956_o() + this.func_174877_v().func_177952_p()) % 200 == 0) {
            this.numUsingPlayers = 0;
            f = 5.0f;
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.func_174877_v().func_177958_n() - f), (double)((float)this.func_174877_v().func_177956_o() - f), (double)((float)this.func_174877_v().func_177952_p() - f), (double)((float)(this.func_174877_v().func_177958_n() + 1) + f), (double)((float)(this.func_174877_v().func_177956_o() + 1) + f), (double)((float)(this.func_174877_v().func_177952_p() + 1) + f)));
            for (EntityPlayer entityplayer : list) {
                if (!(entityplayer.field_71070_bA instanceof ContainerParaChest)) continue;
                ++this.numUsingPlayers;
            }
        }
        this.prevLidAngle = this.lidAngle;
        f = 0.1f;
        if (this.numUsingPlayers > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)this.func_174877_v().func_177958_n() + 0.5;
            double d0 = (double)this.func_174877_v().func_177952_p() + 0.5;
            this.field_145850_b.func_184148_a(null, d1, (double)this.func_174877_v().func_177956_o() + 0.5, d0, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numUsingPlayers == 0 && this.lidAngle > 0.0f || this.numUsingPlayers > 0 && this.lidAngle < 1.0f) {
            float f2;
            float f1 = this.lidAngle;
            this.lidAngle = this.numUsingPlayers > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                double d0 = (double)this.func_174877_v().func_177958_n() + 0.5;
                double d2 = (double)this.func_174877_v().func_177952_p() + 0.5;
                this.field_145850_b.func_184148_a(null, d0, (double)this.func_174877_v().func_177956_o() + 0.5, d2, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            this.checkFluidTankTransfer(this.getInventory().size() - 1, this.fuelTank);
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidUtil.tryFillContainerFuel(tank, this.getInventory(), slot);
    }

    public boolean func_145842_c(int par1, int par2) {
        if (par1 == 1) {
            this.numUsingPlayers = par2;
            return true;
        }
        return super.func_145842_c(par1, par2);
    }

    @Override
    public void func_174889_b(EntityPlayer player) {
        if (this.numUsingPlayers < 0) {
            this.numUsingPlayers = 0;
        }
        ++this.numUsingPlayers;
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numUsingPlayers);
        this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), false);
        this.field_145850_b.func_175685_c(this.func_174877_v().func_177977_b(), this.func_145838_q(), false);
    }

    @Override
    public void func_174886_c(EntityPlayer player) {
        if (this.func_145838_q() != null && this.func_145838_q() instanceof BlockParaChest) {
            --this.numUsingPlayers;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 1, this.numUsingPlayers);
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q(), false);
            this.field_145850_b.func_175685_c(this.func_174877_v().func_177977_b(), this.func_145838_q(), false);
        }
    }

    @Override
    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.func_145836_u();
    }

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        EnumDyeColor color = this.color;
        super.decodePacketdata(buffer);
        if (this.field_145850_b.field_72995_K && color != this.color) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }
}

