/*
 * Decompiled with CFR 0.152.
 */
package openmods.config.properties;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import openmods.config.properties.ConfigPropertyMeta;

public class ConfigProcessing {
    private static final Map<String, ModConfig> configs = Maps.newHashMap();

    public static Collection<String> getConfigsIds() {
        return Collections.unmodifiableCollection(configs.keySet());
    }

    public static ModConfig getConfig(String modId) {
        return configs.get(modId.toLowerCase(Locale.ENGLISH));
    }

    public static void processAnnotations(String modId, Configuration config, Class<?> klazz) {
        Preconditions.checkState((!configs.containsKey(modId) ? 1 : 0) != 0, (String)"Trying to configure mod '%s' twice", (Object)modId);
        ModConfig configMeta = new ModConfig(modId, config, klazz);
        configs.put(modId.toLowerCase(Locale.ENGLISH), configMeta);
        for (Field f : klazz.getFields()) {
            configMeta.tryProcessConfig(f);
        }
    }

    public static class ModConfig {
        private final Configuration config;
        public final Class<?> configClass;
        public final String modId;
        private Table<String, String, ConfigPropertyMeta> properties = HashBasedTable.create();

        private ModConfig(String modId, Configuration config, Class<?> configClass) {
            this.modId = modId;
            this.config = config;
            this.configClass = configClass;
        }

        void tryProcessConfig(Field field) {
            ConfigPropertyMeta meta = ConfigPropertyMeta.createMetaForField(this.config, field);
            if (meta != null) {
                meta.updateValueFromConfig(false);
                this.properties.put((Object)meta.category.toLowerCase(Locale.ENGLISH), (Object)meta.name.toLowerCase(Locale.ENGLISH), (Object)meta);
            }
        }

        public File getConfigFile() {
            return this.config.getConfigFile();
        }

        public void save() {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }

        public Collection<String> getCategories() {
            return Collections.unmodifiableCollection(this.properties.rowKeySet());
        }

        public Collection<String> getValues(String category) {
            return Collections.unmodifiableCollection(this.properties.row((Object)category.toLowerCase(Locale.ENGLISH)).keySet());
        }

        public ConfigPropertyMeta getValue(String category, String name) {
            return (ConfigPropertyMeta)this.properties.get((Object)category.toLowerCase(Locale.ENGLISH), (Object)name.toLowerCase(Locale.ENGLISH));
        }
    }
}

