/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import openmods.utils.CachedFactory;

public class EnumUtils {
    private static final CachedFactory<Class<? extends Enum<?>>, EnumMappings<?>> mappings = new CachedFactory<Class<? extends Enum<?>>, EnumMappings<?>>(){

        @Override
        protected EnumMappings<?> create(Class<? extends Enum<?>> key) {
            return new EnumMappings(key);
        }
    };

    public static <T extends Enum<T>> T fromOrdinal(Class<T> cls, int ordinal) {
        EnumMappings<?> mapping = mappings.getOrCreate(cls);
        return (T)mapping.getValue(ordinal);
    }

    private static class EnumMappings<T extends Enum<T>> {
        private final TIntObjectMap<T> idToValue = new TIntObjectHashMap();

        public EnumMappings(Class<T> enumCls) {
            for (Enum value : (Enum[])enumCls.getEnumConstants()) {
                this.idToValue.put(value.ordinal(), (Object)value);
            }
        }

        public T getValue(int id) {
            return (T)((Enum)this.idToValue.get(id));
        }
    }
}

