/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidBucketWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    @Nonnull
    protected aip container;

    public FluidBucketWrapper(@Nonnull aip container) {
        this.container = container;
    }

    @Override
    @Nonnull
    public aip getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        Fluid fluid = fluidStack.getFluid();
        if (fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA || fluid.getName().equals("milk")) {
            return true;
        }
        return FluidRegistry.isUniversalBucketEnabled() && FluidRegistry.hasBucket(fluid);
    }

    @Nullable
    public FluidStack getFluid() {
        ain item = this.container.c();
        if (item == air.aA) {
            return new FluidStack(FluidRegistry.WATER, 1000);
        }
        if (item == air.aB) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        if (item == air.aO) {
            return FluidRegistry.getFluidStack("milk", 1000);
        }
        if (item == ForgeModContainer.getInstance().universalBucket) {
            return ForgeModContainer.getInstance().universalBucket.getFluid(this.container);
        }
        return null;
    }

    @Deprecated
    protected void setFluid(@Nullable Fluid fluid) {
        this.setFluid(new FluidStack(fluid, 1000));
    }

    protected void setFluid(@Nullable FluidStack fluidStack) {
        this.container = fluidStack == null ? new aip(air.az) : FluidUtil.getFilledBucket(fluidStack);
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.E() != 1 || resource == null || resource.amount < 1000 || this.container.c() instanceof aix || this.getFluid() != null || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (doFill) {
            this.setFluid(resource);
        }
        return 1000;
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.E() != 1 || resource == null || resource.amount < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
            if (doDrain) {
                this.setFluid((FluidStack)null);
            }
            return fluidStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.E() != 1 || maxDrain < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            if (doDrain) {
                this.setFluid((FluidStack)null);
            }
            return fluidStack;
        }
        return null;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable fa facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable fa facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast(this);
        }
        return null;
    }
}

