/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import lumien.randomthings.block.BlockBlockDestabilizer;
import lumien.randomthings.config.Numbers;
import lumien.randomthings.entitys.EntityFallingBlockSpecial;
import lumien.randomthings.lib.ContainerSynced;
import lumien.randomthings.lib.IRedstoneSensitive;
import lumien.randomthings.tileentity.TileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntityBlockDestabilizer
extends TileEntityBase
implements ITickable,
IRedstoneSensitive {
    STATE state = STATE.IDLE;
    HashSet<BlockPos> alreadyChecked;
    ArrayList<BlockPos> toCheck;
    HashSet<BlockPos> targetBlocks;
    IBlockState targetState;
    ArrayList<BlockPos> targetBlocksSorted;
    int dropCounter;
    @ContainerSynced
    boolean lazy;
    @ContainerSynced
    boolean fuzzy;
    HashSet<BlockPos> invalidBlocks;

    public void resetLazy() {
        if (this.state == STATE.IDLE) {
            this.invalidBlocks = null;
        }
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound, boolean sync) {
        compound.func_74768_a("state", this.state.ordinal());
        compound.func_74757_a("lazy", this.lazy);
        compound.func_74757_a("fuzzy", this.fuzzy);
        if (this.lazy && this.invalidBlocks != null) {
            NBTTagList invalidBlocksNBT = new NBTTagList();
            for (BlockPos blockPos : this.invalidBlocks) {
                invalidBlocksNBT.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177958_n()));
                invalidBlocksNBT.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177956_o()));
                invalidBlocksNBT.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177952_p()));
            }
            compound.func_74782_a("invalidBlocks", (NBTBase)invalidBlocksNBT);
        }
        if (this.state == STATE.SEARCHING) {
            NBTTagList alreadyCheckedNBT = new NBTTagList();
            for (BlockPos blockPos : this.alreadyChecked) {
                alreadyCheckedNBT.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177958_n()));
                alreadyCheckedNBT.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177956_o()));
                alreadyCheckedNBT.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177952_p()));
            }
            NBTTagList toCheckNBT = new NBTTagList();
            for (BlockPos p : this.toCheck) {
                toCheckNBT.func_74742_a((NBTBase)new NBTTagInt(p.func_177958_n()));
                toCheckNBT.func_74742_a((NBTBase)new NBTTagInt(p.func_177956_o()));
                toCheckNBT.func_74742_a((NBTBase)new NBTTagInt(p.func_177952_p()));
            }
            NBTTagList nBTTagList = new NBTTagList();
            for (BlockPos p : this.targetBlocks) {
                nBTTagList.func_74742_a((NBTBase)new NBTTagInt(p.func_177958_n()));
                nBTTagList.func_74742_a((NBTBase)new NBTTagInt(p.func_177956_o()));
                nBTTagList.func_74742_a((NBTBase)new NBTTagInt(p.func_177952_p()));
            }
            compound.func_74778_a("targetStateBlock", this.targetState.func_177230_c().getRegistryName().toString());
            compound.func_74768_a("targetStateMeta", this.targetState.func_177230_c().func_176201_c(this.targetState));
            compound.func_74782_a("alreadyChecked", (NBTBase)alreadyCheckedNBT);
            compound.func_74782_a("toCheck", (NBTBase)toCheckNBT);
            compound.func_74782_a("targetBlocks", (NBTBase)nBTTagList);
        } else if (this.state == STATE.DROPPING) {
            compound.func_74768_a("dropCounter", this.dropCounter);
            NBTTagList targetBlocksSortedNBT = new NBTTagList();
            for (BlockPos blockPos : this.targetBlocksSorted) {
                targetBlocksSortedNBT.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177958_n()));
                targetBlocksSortedNBT.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177956_o()));
                targetBlocksSortedNBT.func_74742_a((NBTBase)new NBTTagInt(blockPos.func_177952_p()));
            }
            compound.func_74782_a("targetBlocksSorted", (NBTBase)targetBlocksSortedNBT);
            compound.func_74778_a("targetStateBlock", this.targetState.func_177230_c().getRegistryName().toString());
            compound.func_74768_a("targetStateMeta", this.targetState.func_177230_c().func_176201_c(this.targetState));
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound, boolean sync) {
        BlockPos pos;
        int i;
        this.state = STATE.values()[compound.func_74762_e("state")];
        this.lazy = compound.func_74767_n("lazy");
        this.fuzzy = compound.func_74767_n("fuzzy");
        if (this.lazy && compound.func_74764_b("invalidBlocks")) {
            this.invalidBlocks = new HashSet();
            NBTTagList invalidBlocksNBT = compound.func_150295_c("invalidBlocks", 3);
            for (i = 0; i < invalidBlocksNBT.func_74745_c(); i += 3) {
                pos = new BlockPos(invalidBlocksNBT.func_186858_c(i), invalidBlocksNBT.func_186858_c(i + 1), invalidBlocksNBT.func_186858_c(i + 2));
                this.invalidBlocks.add(pos);
            }
        }
        if (this.state == STATE.SEARCHING) {
            this.toCheck = new ArrayList();
            this.targetBlocks = new HashSet();
            this.alreadyChecked = new HashSet();
            NBTTagList alreadyCheckedNBT = compound.func_150295_c("alreadyChecked", 3);
            for (i = 0; i < alreadyCheckedNBT.func_74745_c(); i += 3) {
                pos = new BlockPos(alreadyCheckedNBT.func_186858_c(i), alreadyCheckedNBT.func_186858_c(i + 1), alreadyCheckedNBT.func_186858_c(i + 2));
                this.alreadyChecked.add(pos);
            }
            NBTTagList toCheckNBT = compound.func_150295_c("toCheck", 3);
            for (int i2 = 0; i2 < toCheckNBT.func_74745_c(); i2 += 3) {
                BlockPos pos2 = new BlockPos(toCheckNBT.func_186858_c(i2), toCheckNBT.func_186858_c(i2 + 1), toCheckNBT.func_186858_c(i2 + 2));
                this.toCheck.add(pos2);
            }
            NBTTagList targetBlocksNBT = compound.func_150295_c("targetBlocks", 3);
            for (int i3 = 0; i3 < targetBlocksNBT.func_74745_c(); i3 += 3) {
                BlockPos pos3 = new BlockPos(targetBlocksNBT.func_186858_c(i3), targetBlocksNBT.func_186858_c(i3 + 1), targetBlocksNBT.func_186858_c(i3 + 2));
                this.targetBlocks.add(pos3);
            }
            String targetBlockName = compound.func_74779_i("targetStateBlock");
            int targetBlockMeta = compound.func_74762_e("targetStateMeta");
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(targetBlockName));
            this.targetState = b == null ? Blocks.field_150348_b.func_176223_P() : b.func_176203_a(targetBlockMeta);
        } else if (this.state == STATE.DROPPING) {
            this.targetBlocksSorted = new ArrayList();
            this.dropCounter = compound.func_74762_e("dropCounter");
            NBTTagList targetBlocksSortedNBT = compound.func_150295_c("targetBlocksSorted", 3);
            for (i = 0; i < targetBlocksSortedNBT.func_74745_c(); i += 3) {
                pos = new BlockPos(targetBlocksSortedNBT.func_186858_c(i), targetBlocksSortedNBT.func_186858_c(i + 1), targetBlocksSortedNBT.func_186858_c(i + 2));
                this.targetBlocksSorted.add(pos);
            }
            String targetBlockName = compound.func_74779_i("targetStateBlock");
            int targetBlockMeta = compound.func_74762_e("targetStateMeta");
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(targetBlockName));
            this.targetState = b == null ? Blocks.field_150348_b.func_176223_P() : b.func_176203_a(targetBlockMeta);
        }
    }

    @Override
    public boolean syncAdditionalData() {
        return false;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.state == STATE.SEARCHING) {
                this.stepSearch();
            } else if (this.state == STATE.DROPPING) {
                this.dropNextBlock();
            }
        }
    }

    private void dropNextBlock() {
        if (this.dropCounter < this.targetBlocksSorted.size()) {
            BlockPos pos = this.targetBlocksSorted.get(this.dropCounter);
            IBlockState target = this.field_145850_b.func_180495_p(pos);
            if ((this.fuzzy && target.func_177230_c() == this.targetState.func_177230_c() || target == this.targetState) && this.field_145850_b.func_175625_s(pos) == null) {
                EntityFallingBlockSpecial fallingEntity = new EntityFallingBlockSpecial(this.field_145850_b, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, target);
                this.field_145850_b.func_72838_d((Entity)fallingEntity);
                fallingEntity.shouldDropItem = false;
            }
            ++this.dropCounter;
        } else {
            this.state = STATE.IDLE;
            this.targetBlocksSorted = null;
            this.targetState = null;
        }
    }

    private void initDrop() {
        this.targetBlocksSorted = new ArrayList<BlockPos>(this.targetBlocks);
        long time = System.currentTimeMillis();
        this.targetBlocksSorted.sort(new Comparator<BlockPos>(){

            @Override
            public int compare(BlockPos o1, BlockPos o2) {
                int difY = o1.func_177956_o() - o2.func_177956_o();
                if (difY != 0) {
                    return difY;
                }
                BlockPos me = TileEntityBlockDestabilizer.this.field_174879_c;
                return (int)(o1.func_177951_i((Vec3i)me) - o2.func_177951_i((Vec3i)me));
            }
        });
        this.state = STATE.DROPPING;
        this.dropCounter = 0;
        this.targetBlocks = null;
        this.toCheck = null;
        this.alreadyChecked = null;
    }

    private void stepSearch() {
        if (this.toCheck.isEmpty() || Numbers.BLOCK_DESTABILIZER_LIMIT != 0 && this.targetBlocks.size() >= Numbers.BLOCK_DESTABILIZER_LIMIT) {
            this.initDrop();
        } else {
            BlockPos nextPos = this.toCheck.remove(0);
            if (!this.alreadyChecked.contains(nextPos)) {
                IBlockState state = this.field_145850_b.func_180495_p(nextPos);
                this.alreadyChecked.add(nextPos);
                if (this.fuzzy && state.func_177230_c() == this.targetState.func_177230_c() || state == this.targetState) {
                    this.targetBlocks.add(nextPos);
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        BlockPos addPos = new BlockPos((Vec3i)nextPos.func_177972_a(facing));
                        if (this.alreadyChecked.contains(addPos)) continue;
                        this.toCheck.add(addPos);
                    }
                } else if (this.lazy) {
                    this.invalidBlocks.add(nextPos);
                }
            }
        }
    }

    private void initStart() {
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBlockDestabilizer.FACING);
        if (!this.field_145850_b.func_175623_d(this.field_174879_c.func_177972_a(facing))) {
            this.targetState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing));
            if (this.targetState.func_185887_b(this.field_145850_b, this.field_174879_c.func_177972_a(facing)) >= 0.0f) {
                this.state = STATE.SEARCHING;
                this.toCheck = new ArrayList();
                this.toCheck.add(this.field_174879_c.func_177972_a(facing));
                this.targetBlocks = new HashSet();
                this.alreadyChecked = new HashSet();
                if (this.lazy) {
                    if (this.invalidBlocks != null) {
                        this.alreadyChecked.addAll(this.invalidBlocks);
                    } else {
                        this.invalidBlocks = new HashSet();
                    }
                } else {
                    this.invalidBlocks = null;
                }
            } else {
                this.targetState = null;
            }
        }
    }

    @Override
    public void redstoneChange(boolean oldState, boolean newState) {
        if (!oldState && newState && this.state == STATE.IDLE) {
            this.initStart();
        }
    }

    public void toggleLazy() {
        if (this.state == STATE.IDLE) {
            boolean bl = this.lazy = !this.lazy;
            if (!this.lazy) {
                this.invalidBlocks = null;
            }
        }
    }

    public void toggleFuzzy() {
        this.fuzzy = !this.fuzzy;
    }

    static enum STATE {
        IDLE,
        SEARCHING,
        DROPPING;

    }
}

