/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon;

import asmodeuscore.core.astronomy.dimension.world.gen.dungeons.standart.DungeonConfiguration;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.DungeonStartIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.PieceIo;
import galaxyspace.systems.SolarSystem.moons.io.world.gen.dungeon.SizedPieceIo;
import java.lang.reflect.Constructor;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;

public abstract class DirectionalPieceIo
extends PieceIo {
    private EnumFacing direction;

    public DirectionalPieceIo() {
    }

    public DirectionalPieceIo(DungeonConfiguration configuration, EnumFacing direction) {
        super(configuration);
        this.direction = direction;
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74768_a("direction", this.direction.ordinal());
    }

    @Override
    protected void func_143011_b(NBTTagCompound nbt, TemplateManager manager) {
        super.func_143011_b(nbt, manager);
        this.direction = nbt.func_74764_b("direction") ? EnumFacing.func_82600_a((int)nbt.func_74762_e("direction")) : EnumFacing.NORTH;
    }

    public PieceIo getCorridor(Random rand, DungeonStartIo startPiece, int maxAttempts, boolean small) {
        return this.getCorridor(rand, startPiece, maxAttempts, small, 6);
    }

    public PieceIo getCorridor(Random rand, DungeonStartIo startPiece, int maxAttempts, boolean small, int width) {
        int sizeZ;
        int sizeX;
        int blockZ;
        int blockX;
        EnumFacing randomDir;
        StructureBoundingBox extension;
        boolean valid;
        int attempts = maxAttempts;
        do {
            int randDir;
            randomDir = EnumFacing.func_176731_b((int)(((randDir = rand.nextInt(4)) == this.getDirection().func_176734_d().func_176736_b() ? randDir + 1 : randDir) % 4));
            extension = this.getExtension(randomDir, this.configuration.getHallwayLengthMin() + rand.nextInt(this.configuration.getHallwayLengthMax() - this.configuration.getHallwayLengthMin()), width);
            blockX = extension.field_78897_a;
            blockZ = extension.field_78896_c;
            sizeX = extension.field_78893_d - extension.field_78897_a;
            sizeZ = extension.field_78892_f - extension.field_78896_c;
        } while (!(valid = !startPiece.checkIntersection(extension)) && --attempts > 0);
        if (!valid) {
            return null;
        }
        return this.getRoom(this.configuration.getCorridor(), startPiece, rand, blockX, blockZ, sizeX, small ? 6 : this.configuration.getHallwayHeight(), sizeZ, randomDir);
    }

    private <T extends SizedPieceIo> T getRoom(Class<?> clazz, DungeonStartIo startPiece, Random rand, int blockX, int blockZ, int sizeX, int sizeY, int sizeZ, EnumFacing randomDir) {
        try {
            Constructor<?> c1 = clazz.getConstructor(DungeonConfiguration.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            return (T)((Object)((SizedPieceIo)((Object)c1.newInstance(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, randomDir))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

