/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.titan.dimension;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.dimension.IProviderFog;
import asmodeuscore.api.dimension.IProviderFreeze;
import asmodeuscore.core.astronomy.dimension.world.gen.WorldProviderAdvancedSpace;
import galaxyspace.core.client.fx.ParticleRainCustom;
import galaxyspace.core.util.GSDimensions;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.ChunkProviderTitan;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.sky.SkyProviderTitan;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.sky.WeatherProviderTitan;
import galaxyspace.systems.SolarSystem.moons.titan.world.gen.BiomeProviderTitan;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IWeatherProvider;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldProviderTitan
extends WorldProviderAdvancedSpace
implements IProviderFreeze,
IProviderFog,
IWeatherProvider {
    public double getHorizon() {
        return 44.0;
    }

    public float getFallDamageModifier() {
        return 0.16f;
    }

    public double getFuelUsageMultiplier() {
        return 0.8;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public float getSoundVolReductionAmount() {
        return Float.MAX_VALUE;
    }

    public boolean canRainOrSnow() {
        return true;
    }

    public CelestialBody getCelestialBody() {
        return SolarSystemBodies.titanSaturn;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderTitan.class;
    }

    public Class<? extends BiomeProvider> getBiomeProviderClass() {
        return BiomeProviderTitan.class;
    }

    public Vector3 getFogColor() {
        float f = 1.0f;
        return new Vector3((double)(0.8784314f * f), (double)(0.68235296f * f), (double)(0.5176471f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f) - this.field_76579_a.func_72867_j(1.0f) / 4.0f;
        return new Vector3((double)(0.8f * f), (double)(0.4745098f * f), (double)(0.20784314f * f));
    }

    public boolean func_76561_g() {
        return true;
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d getCloudColor(float partialTicks) {
        float f = this.field_76579_a.func_72826_c(partialTicks);
        float f1 = MathHelper.func_76134_b((float)(f * ((float)Math.PI * 2))) * 2.0f + 0.5f;
        f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = this.field_76579_a.func_72867_j(partialTicks);
        if (a > 0.0f) {
            float f6 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.6f;
            float f7 = 1.0f - a * 0.95f;
            r = r * f7 + f6 * (1.0f - f7);
            g = g * f7 + f6 * (1.0f - f7);
            b = b * f7 + f6 * (1.0f - f7);
        }
        r *= f1 * 0.9f + 0.1f;
        g *= f1 * 0.9f + 0.1f;
        b *= f1 * 0.85f + 0.15f;
        float f9 = this.field_76579_a.func_72819_i(partialTicks);
        if (f9 > 0.0f) {
            float f10 = (r * 0.3f + g * 0.59f + b * 0.11f) * 0.2f;
            float f8 = 1.0f - f9 * 0.95f;
            r = r * f8 + f10 * (1.0f - f8);
            g = g * f8 + f10 * (1.0f - f8);
            b = b * f8 + f10 * (1.0f - f8);
        }
        return new Vec3d((double)r, (double)g, (double)b);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return 180.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        return new WeatherProviderTitan();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer((IRenderHandler)new SkyProviderTitan());
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public Particle getParticle(WorldClient world, double x, double y, double z) {
        return new ParticleRainCustom((World)world, x, y + 0.1, z, 0.0, 0.0, 0.0, EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), 1.0f, new Vector3(1.0, (double)0.4f, 0.0));
    }

    public int getDungeonSpacing() {
        return 0;
    }

    public ResourceLocation getDungeonChestType() {
        return null;
    }

    public List<Block> getSurfaceBlocks() {
        return null;
    }

    public DimensionType func_186058_p() {
        return GSDimensions.TITAN;
    }

    public float getFogDensity(int x, int y, int z) {
        return 0.3f;
    }

    public int getFogColor(int x, int y, int z) {
        return GSUtils.getColor(224, 174, 132, 1);
    }

    public IAdvancedSpace.ClassBody getClassBody() {
        return IAdvancedSpace.ClassBody.TITAN;
    }

    public void weatherSounds(int j, Minecraft mc, World world, BlockPos blockpos, double xx, double yy, double zz, Random random) {
        if ((int)yy >= blockpos.func_177956_o() + 1 && world.func_175725_q(blockpos).func_177956_o() > blockpos.func_177956_o()) {
            mc.field_71441_e.func_184134_a(xx, yy, zz, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.025f, 0.6f + random.nextFloat() * 0.2f, false);
        } else {
            mc.field_71441_e.func_184134_a(xx, yy, zz, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.04f, 0.8f + random.nextFloat() * 0.06f + random.nextFloat() * 0.06f, false);
        }
    }

    public int getSoundInterval(float rainStrength) {
        int result = 80 - (int)(rainStrength * 88.0f);
        return result > 0 ? result : 0;
    }

    public boolean enableAdvancedThermalLevel() {
        return false;
    }
}

