/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.base.Predicate;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.api.farming.ISoil;
import forestry.core.utils.Translator;
import forestry.core.utils.VectUtil;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class FarmLogic
implements IFarmLogic {
    private final EntitySelectorFarm entitySelectorFarm = new EntitySelectorFarm(this);
    protected final IFarmProperties properties;
    protected final boolean isManual;

    public FarmLogic(IFarmProperties properties, boolean isManual) {
        this.properties = properties;
        this.isManual = isManual;
    }

    protected Collection<IFarmable> getFarmables() {
        return this.properties.getFarmables();
    }

    protected Collection<ISoil> getSoils() {
        return this.properties.getSoils();
    }

    @Override
    public String getName() {
        String unformatted = this.isManual ? "for.farm.grammar.manual" : "for.farm.grammar.managed";
        return Translator.translateToLocalFormatted(unformatted, Translator.translateToLocal(this.getUnlocalizedName()));
    }

    @Override
    public FarmLogic setManual(boolean flag) {
        return this;
    }

    @Override
    public IFarmProperties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isManual() {
        return this.isManual;
    }

    @Override
    public Collection<ICrop> harvest(World world, IFarmHousing housing, BlockPos pos, FarmDirection direction, int extent) {
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, i);
            ICrop crop = this.getCrop(world, position);
            if (crop == null) continue;
            crops.push(crop);
        }
        return crops;
    }

    @Nullable
    protected ICrop getCrop(World world, BlockPos position) {
        if (!world.func_175667_e(position) || world.func_175623_d(position)) {
            return null;
        }
        IBlockState blockState = world.func_180495_p(position);
        for (IFarmable seed : this.getFarmables()) {
            ICrop crop = seed.getCropAt(world, position, blockState);
            if (crop == null) continue;
            return crop;
        }
        return null;
    }

    public abstract boolean isAcceptedWindfall(ItemStack var1);

    protected final boolean isWaterSourceBlock(World world, BlockPos position) {
        if (!world.func_175667_e(position)) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        return block == Blocks.field_150355_j;
    }

    protected final boolean isIceBlock(World world, BlockPos position) {
        if (!world.func_175667_e(position)) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        return block == Blocks.field_150432_aD;
    }

    protected final BlockPos translateWithOffset(BlockPos pos, FarmDirection farmDirection, int step) {
        return VectUtil.scale(farmDirection.getFacing().func_176730_m(), step).func_177971_a((Vec3i)pos);
    }

    private static AxisAlignedBB getHarvestBox(World world, IFarmHousing farmHousing, boolean toWorldHeight) {
        BlockPos coords = farmHousing.getCoords();
        Vec3i area = farmHousing.getArea();
        Vec3i offset = farmHousing.getOffset();
        BlockPos min = coords.func_177971_a(offset);
        BlockPos max = min.func_177971_a(area);
        int maxY = max.func_177956_o();
        if (toWorldHeight) {
            maxY = world.func_72800_K();
        }
        return new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)max.func_177958_n(), (double)maxY, (double)max.func_177952_p());
    }

    protected NonNullList<ItemStack> collectEntityItems(World world, IFarmHousing farmHousing, boolean toWorldHeight) {
        AxisAlignedBB harvestBox = FarmLogic.getHarvestBox(world, farmHousing, toWorldHeight);
        List entityItems = world.func_175647_a(EntityItem.class, harvestBox, (Predicate)this.entitySelectorFarm);
        NonNullList stacks = NonNullList.func_191196_a();
        for (EntityItem entity : entityItems) {
            ItemStack contained = entity.func_92059_d();
            stacks.add((Object)contained.func_77946_l());
            entity.func_70106_y();
        }
        return stacks;
    }

    public String toString() {
        return this.getName();
    }

    private static class EntitySelectorFarm
    implements Predicate<EntityItem> {
        private final FarmLogic farmLogic;

        public EntitySelectorFarm(FarmLogic farmLogic) {
            this.farmLogic = farmLogic;
        }

        public boolean apply(@Nullable EntityItem entity) {
            if (entity == null || entity.field_70128_L) {
                return false;
            }
            if (entity.getEntityData().func_74767_n("PreventRemoteMovement")) {
                return false;
            }
            ItemStack contained = entity.func_92059_d();
            return this.farmLogic.isAcceptedGermling(contained) || this.farmLogic.isAcceptedWindfall(contained);
        }
    }
}

