/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.util;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackOreMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CompactingHelper {
    private static InventoryLookup lookup1 = new InventoryLookup(1, 1);
    private static InventoryLookup lookup2 = new InventoryLookup(2, 2);
    private static InventoryLookup lookup3 = new InventoryLookup(3, 3);
    private World world;

    public CompactingHelper(World world) {
        this.world = world;
    }

    @Nonnull
    public Result findHigherTier(@Nonnull ItemStack stack) {
        ItemStack modMatch;
        CompTierRegistry.Record record;
        if (!this.world.field_72995_K && StorageDrawers.config.cache.debugTrace) {
            StorageDrawers.log.info("Finding ascending candidates for " + stack.toString());
        }
        if ((record = StorageDrawers.compRegistry.findHigherTier(stack)) != null) {
            if (!this.world.field_72995_K && StorageDrawers.config.cache.debugTrace) {
                StorageDrawers.log.info("Found " + record.upper.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.upper, record.convRate);
        }
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        int lookupSize = this.setupLookup(lookup3, stack);
        List<ItemStack> fwdCandidates = this.findAllMatchingRecipes(lookup3);
        if (fwdCandidates.size() == 0) {
            lookupSize = this.setupLookup(lookup2, stack);
            fwdCandidates = this.findAllMatchingRecipes(lookup2);
        }
        if (fwdCandidates.size() > 0) {
            block0: for (ItemStack match : fwdCandidates) {
                this.setupLookup(lookup1, match);
                List<ItemStack> backCandidates = this.findAllMatchingRecipes(lookup1);
                for (ItemStack comp : backCandidates) {
                    if (comp.func_190916_E() != lookupSize || !ItemStackOreMatcher.areItemsEqual(comp, stack, false)) continue;
                    candidates.add(match);
                    if (this.world.field_72995_K || !StorageDrawers.config.cache.debugTrace) continue block0;
                    StorageDrawers.log.info("Found ascending candidate for " + stack.toString() + ": " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
                    continue block0;
                }
            }
        }
        if (!(modMatch = this.findMatchingModCandidate(stack, candidates)).func_190926_b()) {
            return new Result(modMatch, lookupSize);
        }
        if (candidates.size() > 0) {
            return new Result((ItemStack)candidates.get(0), lookupSize);
        }
        if (!this.world.field_72995_K && StorageDrawers.config.cache.debugTrace) {
            StorageDrawers.log.info("No candidates found");
        }
        return new Result(ItemStack.field_190927_a, 0);
    }

    @Nonnull
    public Result findLowerTier(@Nonnull ItemStack stack) {
        CompTierRegistry.Record record;
        if (!this.world.field_72995_K && StorageDrawers.config.cache.debugTrace) {
            StorageDrawers.log.info("Finding descending candidates for " + stack.toString());
        }
        if ((record = StorageDrawers.compRegistry.findLowerTier(stack)) != null) {
            if (!this.world.field_72995_K && StorageDrawers.config.cache.debugTrace) {
                StorageDrawers.log.info("Found " + record.lower.toString() + " in registry with conv=" + record.convRate);
            }
            return new Result(record.lower, record.convRate);
        }
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        HashMap<ItemStack, Integer> candidatesRate = new HashMap<ItemStack, Integer>();
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            ItemStack match;
            ItemStack output = recipe.func_77571_b();
            if (!ItemStackOreMatcher.areItemsEqual(stack, output, true) || (match = this.tryMatch(stack, (NonNullList<Ingredient>)recipe.func_192400_c())).func_190926_b()) continue;
            int lookupSize = this.setupLookup(lookup1, output);
            List<ItemStack> compMatches = this.findAllMatchingRecipes(lookup1);
            for (ItemStack comp : compMatches) {
                int recipeSize = recipe.func_192400_c().size();
                if (ItemStackOreMatcher.areItemsEqual(match, comp, true) && comp.func_190916_E() == recipeSize) {
                    candidates.add(match);
                    candidatesRate.put(match, recipeSize);
                    if (this.world.field_72995_K || !StorageDrawers.config.cache.debugTrace) continue;
                    StorageDrawers.log.info("Found descending candidate for " + stack.toString() + ": " + match.toString() + " size=" + recipeSize + ", inverse=" + comp.toString());
                    continue;
                }
                if (this.world.field_72995_K || !StorageDrawers.config.cache.debugTrace) continue;
                StorageDrawers.log.info("Back-check failed for " + match.toString() + " size=" + lookupSize + ", inverse=" + comp.toString());
            }
        }
        ItemStack modMatch = this.findMatchingModCandidate(stack, candidates);
        if (!modMatch.func_190926_b()) {
            return new Result(modMatch, (Integer)candidatesRate.get(modMatch));
        }
        if (candidates.size() > 0) {
            ItemStack match = (ItemStack)candidates.get(0);
            return new Result(match, (Integer)candidatesRate.get(match));
        }
        if (!this.world.field_72995_K && StorageDrawers.config.cache.debugTrace) {
            StorageDrawers.log.info("No candidates found");
        }
        return new Result(ItemStack.field_190927_a, 0);
    }

    private List<ItemStack> findAllMatchingRecipes(InventoryCrafting crafting) {
        ArrayList<ItemStack> candidates = new ArrayList<ItemStack>();
        for (Object aRecipeList : CraftingManager.field_193380_a) {
            ItemStack result;
            IRecipe recipe = (IRecipe)aRecipeList;
            if (!recipe.func_77569_a(crafting, this.world) || (result = recipe.func_77572_b(crafting)).func_190926_b()) continue;
            candidates.add(result);
        }
        return candidates;
    }

    @Nonnull
    private ItemStack findMatchingModCandidate(@Nonnull ItemStack reference, List<ItemStack> candidates) {
        ResourceLocation referenceName = reference.func_77973_b().getRegistryName();
        if (referenceName != null) {
            for (ItemStack candidate : candidates) {
                ResourceLocation matchName = candidate.func_77973_b().getRegistryName();
                if (matchName == null || !referenceName.func_110624_b().equals(matchName.func_110624_b())) continue;
                return candidate;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    private ItemStack tryMatch(@Nonnull ItemStack stack, NonNullList<Ingredient> ingredients) {
        if (ingredients.size() != 9 && ingredients.size() != 4) {
            return ItemStack.field_190927_a;
        }
        Ingredient refIngredient = (Ingredient)ingredients.get(0);
        ItemStack[] refMatchingStacks = refIngredient.func_193365_a();
        if (refMatchingStacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        int n = ingredients.size();
        for (int i = 1; i < n; ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            ItemStack match = ItemStack.field_190927_a;
            for (ItemStack ingItemMatch : refMatchingStacks) {
                if (!ingredient.apply(ingItemMatch)) continue;
                match = ingItemMatch;
                break;
            }
            if (!match.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        ItemStack match = this.findMatchingModCandidate(stack, Arrays.asList(refMatchingStacks));
        if (match.func_190926_b()) {
            match = refMatchingStacks[0];
        }
        return match;
    }

    private int setupLookup(InventoryLookup inv, @Nonnull ItemStack stack) {
        int n = inv.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            inv.func_70299_a(i, stack);
        }
        return inv.func_70302_i_();
    }

    private static class InventoryLookup
    extends InventoryCrafting {
        private ItemStack[] stackList;

        public InventoryLookup(int width, int height) {
            super(null, width, height);
            this.stackList = new ItemStack[width * height];
            for (int i = 0; i < this.stackList.length; ++i) {
                this.stackList[i] = ItemStack.field_190927_a;
            }
        }

        public int func_70302_i_() {
            return this.stackList.length;
        }

        @Nonnull
        public ItemStack func_70301_a(int slot) {
            return slot >= this.func_70302_i_() ? ItemStack.field_190927_a : this.stackList[slot];
        }

        @Nonnull
        public ItemStack func_70304_b(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack func_70298_a(int slot, int count) {
            return ItemStack.field_190927_a;
        }

        public void func_70299_a(int slot, @Nonnull ItemStack stack) {
            this.stackList[slot] = stack;
        }
    }

    public class Result {
        @Nonnull
        private ItemStack stack;
        private int size;

        public Result(ItemStack stack, int size) {
            this.stack = stack;
            this.size = size;
        }

        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }

        public int getSize() {
            return this.size;
        }
    }
}

