/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.util;

import com.google.common.base.Throwables;
import com.google.gson.JsonParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import team.chisel.ctm.client.texture.IMetadataSectionCTM;

public class ResourceUtil {
    private static final Map<ResourceLocation, IMetadataSectionCTM> metadataCache = new HashMap<ResourceLocation, IMetadataSectionCTM>();

    public static ResourceLocation toResourceLocation(TextureAtlasSprite sprite) {
        return new ResourceLocation(sprite.func_94215_i());
    }

    public static IResource getResource(TextureAtlasSprite sprite) throws IOException {
        return ResourceUtil.getResource(ResourceUtil.spriteToAbsolute(ResourceUtil.toResourceLocation(sprite)));
    }

    public static ResourceLocation spriteToAbsolute(ResourceLocation sprite) {
        if (!sprite.func_110623_a().startsWith("textures/")) {
            sprite = new ResourceLocation(sprite.func_110624_b(), "textures/" + sprite.func_110623_a());
        }
        if (!sprite.func_110623_a().endsWith(".png")) {
            sprite = new ResourceLocation(sprite.func_110624_b(), sprite.func_110623_a() + ".png");
        }
        return sprite;
    }

    public static IResource getResource(ResourceLocation res) throws IOException {
        return Minecraft.func_71410_x().func_110442_L().func_110536_a(res);
    }

    public static IResource getResourceUnsafe(ResourceLocation res) {
        try {
            return ResourceUtil.getResource(res);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @Nullable
    public static IMetadataSectionCTM getMetadata(ResourceLocation res) throws IOException {
        IMetadataSectionCTM ret;
        if (metadataCache.containsKey(res)) {
            return metadataCache.get(res);
        }
        try (IResource resource = ResourceUtil.getResource(res);){
            ret = (IMetadataSectionCTM)resource.func_110526_a("ctm");
        }
        catch (FileNotFoundException e) {
            ret = null;
        }
        catch (JsonParseException e) {
            throw new IOException("Error loading metadata for location " + res, e);
        }
        metadataCache.put(res, ret);
        return ret;
    }

    @Nullable
    public static IMetadataSectionCTM getMetadata(TextureAtlasSprite sprite) throws IOException {
        return ResourceUtil.getMetadata(ResourceUtil.spriteToAbsolute(ResourceUtil.toResourceLocation(sprite)));
    }

    @Nullable
    public static IMetadataSectionCTM getMetadataUnsafe(TextureAtlasSprite sprite) {
        try {
            return ResourceUtil.getMetadata(sprite);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void invalidateCaches() {
        metadataCache.clear();
    }
}

