/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.client;

import com.google.common.collect.Maps;
import erogenousbeef.bigreactors.common.BigReactors;
import java.util.HashMap;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public abstract class BeefIconManager {
    private HashMap<String, Integer> nameToIdMap = Maps.newHashMap();
    private HashMap<Integer, ResourceLocation> idToIconMap = Maps.newHashMap();
    public String[] iconNames = this.getIconNames();

    protected abstract String[] getIconNames();

    protected abstract String getPath();

    public void registerIcons(TextureMap textureMap) {
        if (this.iconNames == null) {
            return;
        }
        String path = this.getPath();
        for (int i = 0; i < this.iconNames.length; ++i) {
            ResourceLocation location = BigReactors.createResourceLocation(path + this.iconNames[i].toLowerCase());
            this.nameToIdMap.put(this.iconNames[i], i);
            textureMap.func_174942_a(location);
            this.idToIconMap.put(i, location);
        }
    }

    public ResourceLocation getIcon(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        Integer id = this.nameToIdMap.get(name);
        if (id == null) {
            return null;
        }
        return this.idToIconMap.get(id);
    }

    public ResourceLocation getIcon(int id) {
        return this.idToIconMap.get(id);
    }
}

