/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.helpers;

import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.data.ReactantStack;
import erogenousbeef.bigreactors.common.multiblock.interfaces.IConditionalUpdater;
import io.netty.buffer.ByteBuf;
import it.zerono.mods.zerocore.lib.IDebugMessages;
import it.zerono.mods.zerocore.lib.IDebuggable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public abstract class ReactantContainer
implements IConditionalUpdater,
IDebuggable {
    private ReactantStack[] tanks;
    private int capacity;
    private String[] tankNames;
    private int ticksSinceLastUpdate;
    private static final int minimumTicksBetweenUpdates = 60;
    private static final float minimumDevianceForUpdate = 0.05f;
    int[] levelAtLastUpdate;
    private static final int FORCE_UPDATE = -1000;

    public ReactantContainer(String[] tankNames, int capacity) {
        assert (tankNames != null);
        assert (tankNames.length > 0);
        this.tankNames = tankNames;
        this.tanks = new ReactantStack[tankNames.length];
        this.levelAtLastUpdate = new int[tankNames.length];
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = null;
            this.levelAtLastUpdate[i] = -1000;
        }
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int newCapacity) {
        int oldCapacity = this.capacity;
        this.capacity = newCapacity;
        this.clampContentsToCapacity();
    }

    public String getReactantType(int reactantIdx) {
        assert (reactantIdx >= 0 && reactantIdx < this.tanks.length);
        return this.tanks[reactantIdx] == null ? null : this.tanks[reactantIdx].getName();
    }

    public int getReactantAmount(int reactantIdx) {
        assert (reactantIdx >= 0 && reactantIdx < this.tanks.length);
        return this.tanks[reactantIdx] == null ? 0 : this.tanks[reactantIdx].amount;
    }

    public int getTotalAmount() {
        int amt = 0;
        for (int i = 0; i < this.tanks.length; ++i) {
            amt += this.getReactantAmount(i);
        }
        return amt;
    }

    public void setReactant(int reactantIdx, ReactantStack newStack) {
        assert (reactantIdx >= 0 && reactantIdx < this.tanks.length);
        this.tanks[reactantIdx] = newStack;
    }

    protected int addToStack(int idx, int fluidAmount) {
        if (this.tanks[idx] == null) {
            throw new IllegalArgumentException("Cannot add reactant with only an integer when tank is empty!");
        }
        int amtToAdd = Math.min(fluidAmount, this.getRemainingSpace());
        this.tanks[idx].amount += amtToAdd;
        return amtToAdd;
    }

    public int fill(int idx, String reactantName, int amount, boolean doFill) {
        assert (idx >= 0 && idx < this.tanks.length);
        if (reactantName == null || amount <= 0) {
            return 0;
        }
        if (!this.canAddToStack(idx, reactantName)) {
            return 0;
        }
        int amtToAdd = Math.min(amount, this.getRemainingSpace());
        if (amtToAdd <= 0) {
            return 0;
        }
        if (!doFill) {
            return amtToAdd;
        }
        if (this.tanks[idx] == null) {
            this.tanks[idx] = new ReactantStack(reactantName, amtToAdd);
        } else {
            this.tanks[idx].amount += amtToAdd;
        }
        return amtToAdd;
    }

    public int dump(int idx) {
        assert (idx >= 0 && idx < this.tanks.length);
        int amt = this.tanks[idx] != null ? this.tanks[idx].amount : 0;
        this.setReactant(idx, null);
        return amt;
    }

    public int dump(int idx, int amount) {
        assert (idx >= 0 && idx < this.tanks.length);
        if (this.tanks[idx] != null) {
            if (this.tanks[idx].amount <= amount) {
                amount = this.tanks[idx].amount;
                this.setReactant(idx, null);
            } else {
                this.tanks[idx].amount -= amount;
            }
            return amount;
        }
        return 0;
    }

    protected abstract boolean isReactantValidForStack(int var1, String var2);

    protected boolean canAddToStack(int idx, String incoming) {
        if (idx < 0 || idx >= this.tanks.length || incoming == null) {
            return false;
        }
        if (this.tanks[idx] == null) {
            return this.isReactantValidForStack(idx, incoming);
        }
        return this.tanks[idx].isReactantEqual(incoming);
    }

    public boolean canDrain(int idx, ReactantStack reactant) {
        if (reactant == null || idx < 0 || idx >= this.tanks.length) {
            return false;
        }
        if (this.tanks[idx] == null) {
            return false;
        }
        return this.tanks[idx].isReactantEqual(reactant) && this.tanks[idx].amount > 0;
    }

    protected NBTTagCompound writeToNBT(NBTTagCompound destination) {
        for (int i = 0; i < this.tankNames.length; ++i) {
            ReactantStack stack = this.tanks[i];
            if (stack == null) continue;
            destination.func_74782_a(this.tankNames[i], (NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        return destination;
    }

    protected void readFromNBT(NBTTagCompound data) {
        for (int i = 0; i < this.tankNames.length; ++i) {
            if (data.func_74764_b(this.tankNames[i])) {
                this.tanks[i] = ReactantStack.createFromNBT(data.func_74775_l(this.tankNames[i]));
                this.levelAtLastUpdate[i] = this.tanks[i] != null ? this.tanks[i].amount : -1000;
                continue;
            }
            this.tanks[i] = null;
            this.levelAtLastUpdate[i] = -1000;
        }
    }

    public void serialize(ByteBuf buffer) {
        buffer.writeInt(this.capacity);
        for (int i = 0; i < this.tankNames.length; ++i) {
            boolean hasReactant = this.getReactantAmount(i) > 0;
            buffer.writeBoolean(hasReactant);
            if (!hasReactant) continue;
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.tanks[i].getName());
            buffer.writeInt(this.tanks[i].amount);
        }
    }

    public void deserialize(ByteBuf buffer) {
        this.capacity = buffer.readInt();
        for (int i = 0; i < this.tankNames.length; ++i) {
            this.tanks[i] = null;
            boolean hasReactant = buffer.readBoolean();
            if (!hasReactant) continue;
            String reactantName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
            int amount = buffer.readInt();
            if (!Reactants.isKnown(reactantName)) {
                BRLog.warning("Read an unknown reactant <%s> from a network message; tank %s will remain empty", reactantName, this.tankNames[i]);
                continue;
            }
            this.tanks[i] = new ReactantStack(reactantName, amount);
            this.levelAtLastUpdate[i] = amount;
        }
    }

    protected void merge(ReactantContainer other) {
        if (other.capacity > this.capacity) {
            this.capacity = other.capacity;
            this.tanks = other.tanks;
        }
    }

    @Override
    public boolean shouldUpdate() {
        ++this.ticksSinceLastUpdate;
        if (60 < this.ticksSinceLastUpdate) {
            int dev = 0;
            boolean shouldUpdate = false;
            for (int i = 0; i < this.tanks.length && !shouldUpdate; ++i) {
                if (this.tanks[i] == null && this.levelAtLastUpdate[i] > 0) {
                    shouldUpdate = true;
                } else if (this.tanks[i] != null) {
                    if (this.levelAtLastUpdate[i] == -1000) {
                        shouldUpdate = true;
                    } else {
                        dev += Math.abs(this.tanks[i].amount - this.levelAtLastUpdate[i]);
                    }
                }
                float divisor = this.capacity;
                if (divisor == 0.0f) {
                    divisor = 4000.0f;
                }
                if (!((float)dev / divisor >= 0.05f)) continue;
                shouldUpdate = true;
            }
            if (shouldUpdate) {
                this.resetLastSeenLevels();
            }
            this.ticksSinceLastUpdate = 0;
            return shouldUpdate;
        }
        return false;
    }

    protected void resetLastSeenLevels() {
        for (int i = 0; i < this.tanks.length; ++i) {
            this.levelAtLastUpdate[i] = this.tanks[i] == null ? 0 : this.tanks[i].amount;
        }
    }

    public int getRemainingSpace() {
        return this.getCapacity() - this.getTotalAmount();
    }

    protected void clampContentsToCapacity() {
        if (this.getTotalAmount() > this.capacity) {
            int diff = this.getTotalAmount() - this.capacity;
            for (int i = this.tanks.length - 1; i >= 0 && diff > 0; --i) {
                if (this.tanks[i] == null) continue;
                if (diff > this.tanks[i].amount) {
                    diff -= this.tanks[i].amount;
                    this.tanks[i] = null;
                    continue;
                }
                this.tanks[i].amount -= diff;
                diff = 0;
            }
        }
    }

    public void getDebugMessages(IDebugMessages messages) {
        messages.add("debug.bigreactors.reactantcontainer.capacity", new Object[]{this.getCapacity()});
        for (int i = 0; i < this.tanks.length; ++i) {
            messages.add("debug.bigreactors.reactantcontainer.tank", new Object[]{Integer.toString(i), this.tankNames[i], null == this.tanks[i] ? "?" : this.tanks[i]});
        }
    }
}

