/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.model;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.malisis.advert.renderer.AdvertRenderer;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.model.MalisisModel;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public abstract class AdvertModel<T extends IModelVariant> {
    private static Map<String, AdvertModel<?>> registry = new HashMap();
    protected String id;
    protected String name;
    protected int availableSlots = 1;
    protected float width;
    protected float height;
    protected ResourceLocation objFile;
    protected ResourceLocation placeHolder;
    protected MalisisModel model;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAvailableSlots() {
        return this.availableSlots;
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return this.height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public ResourceLocation getObjFile() {
        return this.objFile;
    }

    public void setObjFile(ResourceLocation objFile) {
        this.objFile = objFile;
    }

    public ResourceLocation getPlaceHolder() {
        return this.placeHolder;
    }

    public void setPlaceHolder(ResourceLocation placeHolder) {
        this.placeHolder = placeHolder;
    }

    public MalisisModel getModel() {
        return this.model;
    }

    public void setModel(MalisisModel model) {
        this.model = model;
    }

    public boolean canBeWallMounted() {
        return false;
    }

    public void loadModelFile() {
        if (this.objFile == null) {
            return;
        }
        this.model = new MalisisModel(this.objFile);
    }

    public void writeToNBT(AdvertTileEntity tileEntity, NBTTagCompound tagCompound) {
    }

    public void readFromNBT(AdvertTileEntity te, NBTTagCompound tagCompound) {
    }

    public abstract T defaultVariant(boolean var1);

    public abstract AxisAlignedBB[] getBoundingBox(T var1);

    public abstract int getGuiComponent(MalisisGui var1, UIContainer<?> var2, T var3, boolean var4);

    public abstract T getVariantFromGui(UIContainer<?> var1);

    public abstract void renderBlock(AdvertRenderer var1, AdvertTileEntity var2, RenderParameters var3, T var4);

    public abstract void renderTileEntity(AdvertRenderer var1, AdvertTileEntity var2, RenderParameters var3, T var4);

    public String toString() {
        return this.name;
    }

    public static AdvertModel<?> getModel(String id) {
        AdvertModel<?> model = registry.get(id);
        if (model == null) {
            model = registry.get("panel");
        }
        return model;
    }

    public static void register(AdvertModel<?> model) {
        registry.put(model.getId(), model);
        if (!MalisisCore.isClient()) {
            return;
        }
        model.loadModelFile();
    }

    public static Collection<AdvertModel<?>> list() {
        return registry.values();
    }

    public static interface IModelVariant {
        public boolean isWallMounted();

        public void readFromNBT(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound var1);

        public void fromBytes(ByteBuf var1);

        public void toBytes(ByteBuf var1);
    }
}

