/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.model;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.malisis.advert.advert.AdvertSelection;
import net.malisis.advert.model.AdvertModel;
import net.malisis.advert.renderer.AdvertRenderer;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UISelect;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.icon.Icon;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PanelModel
extends AdvertModel<Variant> {
    private Shape smallFoot;
    private Shape fullFoot;
    private Shape panel;
    private Shape displayTop;
    private Shape displayBottom;
    @SideOnly(value=Side.CLIENT)
    private Icon panelIcon;
    private AnimationRenderer ar;
    private ChainedTransformation topTransform;
    private ChainedTransformation bottomTransform;
    private Icon baseIcon;
    private PanelData panelData;

    public PanelModel() {
        this.name = this.id = "panel";
        this.availableSlots = 2;
        float border = 0.1875f;
        this.width = 2.0f - 2.0f * border;
        this.height = 3.0f - 2.0f * border;
        this.objFile = new ResourceLocation("malisisadvert", "models/panel.obj");
        this.placeHolder = new ResourceLocation("malisisadvert", "textures/blocks/MA23.png");
        if (MalisisCore.isClient()) {
            this.panelIcon = Icon.from((String)"malisisadvert:blocks/panel");
        }
    }

    @Override
    public boolean canBeWallMounted() {
        return true;
    }

    @Override
    public void loadModelFile() {
        super.loadModelFile();
        this.smallFoot = this.model.getShape("SmallFoot");
        this.fullFoot = this.model.getShape("FullFoot");
        this.panel = this.model.getShape("Panel");
        this.displayTop = this.model.getShape("Advert");
        this.displayBottom = new Shape(this.displayTop);
        this.model.addShape(this.displayBottom);
        this.ar = new AnimationRenderer();
        this.baseIcon = new Icon();
        this.panelData = new PanelData();
        int speed = 60;
        int delay = 200;
        PanelTransform pt1 = (PanelTransform)((PanelTransform)new PanelTransform(true).forTicks(speed, delay)).movement(1);
        PanelTransform pt2 = (PanelTransform)((PanelTransform)((PanelTransform)new PanelTransform(true).forTicks(speed, delay)).reversed(true)).movement(1);
        this.topTransform = (ChainedTransformation)new ChainedTransformation(new Transformation[]{pt1, pt2}).loop(-1);
        pt1 = (PanelTransform)((PanelTransform)new PanelTransform(false).forTicks(speed, delay)).movement(1);
        pt2 = (PanelTransform)((PanelTransform)((PanelTransform)new PanelTransform(false).forTicks(speed, delay)).reversed(true)).movement(1);
        this.bottomTransform = (ChainedTransformation)new ChainedTransformation(new Transformation[]{pt1, pt2}).loop(-1);
    }

    @Override
    public Variant defaultVariant(boolean wallMounted) {
        Variant variant = new Variant();
        variant.type = wallMounted ? FootType.WALL : FootType.SMALL;
        return variant;
    }

    @Override
    public AxisAlignedBB[] getBoundingBox(Variant variant) {
        AxisAlignedBB[] aabbs;
        float w = 0.1875f;
        AxisAlignedBB foot = new AxisAlignedBB(0.375, 0.0, 0.5, 0.625, 1.0, (double)(0.5f + w));
        AxisAlignedBB panel = new AxisAlignedBB(-0.5, 0.0, 0.5, 1.5, variant.type == FootType.FULL ? 4.0 : 3.0, (double)(0.5f + w));
        if (variant.type == FootType.WALL) {
            panel = panel.func_72317_d(0.0, 0.0, -0.5);
        }
        if (variant.type == FootType.SMALL) {
            panel = panel.func_72317_d(0.0, 1.0, 0.0);
            aabbs = new AxisAlignedBB[]{foot, panel};
        } else {
            aabbs = new AxisAlignedBB[]{panel};
        }
        return aabbs;
    }

    @Override
    public int getGuiComponent(MalisisGui gui, UIContainer<?> container, Variant variant, boolean wallMounted) {
        UILabel label = new UILabel(gui, "malisisadvert.gui.model.panel.type");
        UISelect select = (UISelect)new UISelect(gui, 150, Arrays.asList(FootType.values())).setName("footType");
        select.setLabelPattern("malisisadvert.gui.model.panel.%s");
        select.setPosition(0, 12);
        select.setSelectedOption((Object)variant.type);
        select.setDisablePredicate(t -> wallMounted == (t != FootType.WALL));
        container.add(new UIComponent[]{label});
        container.add(new UIComponent[]{select});
        return 30;
    }

    @Override
    public Variant getVariantFromGui(UIContainer<?> container) {
        Variant variant = new Variant();
        UISelect sel = (UISelect)container.getComponent("footType");
        variant.type = (FootType)((Object)sel.getSelectedValue());
        return variant;
    }

    @Override
    public void renderBlock(AdvertRenderer renderer, AdvertTileEntity tileEntity, RenderParameters rp, Variant variant) {
        rp.icon.set((Object)this.panelIcon);
        if (variant.type == FootType.SMALL) {
            renderer.drawShape(this.smallFoot, rp);
        } else if (variant.type == FootType.FULL) {
            renderer.drawShape(this.fullFoot, rp);
        } else {
            this.panel.translate(0.0f, -1.0f, -0.5f);
        }
        renderer.drawShape(this.panel, rp);
    }

    @Override
    public void renderTileEntity(AdvertRenderer renderer, AdvertTileEntity tileEntity, RenderParameters rp, Variant variant) {
        if (variant.type == FootType.WALL) {
            this.displayTop.translate(0.0f, -1.0f, -0.5f);
            this.displayBottom.translate(0.0f, -1.0f, -0.5f);
        }
        boolean b = tileEntity.getSelection(1) != null;
        this.renderAdvert(renderer, this.displayTop, tileEntity.getSelection(0), this.topTransform, b);
        if (b) {
            this.renderAdvert(renderer, this.displayBottom, tileEntity.getSelection(1), this.bottomTransform, b);
        }
    }

    private void renderAdvert(AdvertRenderer renderer, Shape shape, AdvertSelection as, ChainedTransformation transform, boolean anim) {
        this.panelData.set(shape, as);
        if (anim) {
            this.ar.animate((ITransformable)this.panelData, (Transformation)transform);
        }
        shape.applyMatrix();
        renderer.renderAdvertFace(shape.getFaces()[0], as, this.panelData.icon);
    }

    private class PanelTransform
    extends Transformation<PanelTransform, PanelData> {
        private boolean isTop;

        public PanelTransform(boolean isTop) {
            this.isTop = isTop;
        }

        public PanelTransform self() {
            return this;
        }

        protected void doTransform(PanelData data, float comp) {
            if (this.isTop && comp == 0.0f) {
                return;
            }
            if (!this.isTop && this.reversed && comp == 0.0f) {
                return;
            }
            if (this.reversed) {
                comp = 1.0f - comp;
            }
            this.transformVertex(data, comp);
            this.transformIcon(data, comp);
        }

        private void transformVertex(PanelData data, float comp) {
            Vertex[] vertexes;
            double amount = (data.Y - data.y) * (double)comp;
            Face f = data.shape.getFaces()[0];
            for (Vertex v : vertexes = new Vertex[]{f.getVertexes()[this.isTop ? 0 : 2], f.getVertexes()[this.isTop ? 1 : 3]}) {
                v.setY(data.y + amount);
            }
        }

        private void transformIcon(PanelData data, float comp) {
            float amount = (data.V - data.v) * comp;
            float v = this.isTop ? data.v + amount : data.v;
            float V = this.isTop ? data.V : data.v + amount;
            data.icon.setUVs(data.icon.func_94209_e(), v, data.icon.func_94212_f(), V);
        }

        public float completion(long elapsedTime) {
            return super.completion(elapsedTime);
        }
    }

    private class PanelData
    implements ITransformable {
        private double y;
        private double Y;
        private float v;
        private float V;
        private Shape shape;
        private Icon icon;

        private PanelData() {
        }

        public void set(Shape shape, AdvertSelection as) {
            Icon icon;
            this.shape = shape;
            Icon icon2 = icon = as != null ? as.getIcon() : null;
            if (icon == null) {
                icon = PanelModel.this.baseIcon;
            }
            this.icon = icon.copy();
            Face f = shape.getFaces()[0];
            this.y = f.getVertexes()[0].getY();
            this.Y = f.getVertexes()[2].getY();
            this.v = icon.func_94206_g();
            this.V = icon.func_94210_h();
        }
    }

    public static class Variant
    implements AdvertModel.IModelVariant {
        public FootType type = FootType.SMALL;

        @Override
        public boolean isWallMounted() {
            return this.type == FootType.WALL;
        }

        @Override
        public void readFromNBT(NBTTagCompound tagCompound) {
            this.type = tagCompound.func_74764_b("footType") ? FootType.values()[tagCompound.func_74762_e("footType")] : FootType.SMALL;
        }

        @Override
        public void writeToNBT(NBTTagCompound tagCompound) {
            tagCompound.func_74768_a("footType", this.type.ordinal());
        }

        @Override
        public void fromBytes(ByteBuf buf) {
            this.type = FootType.values()[buf.readInt()];
        }

        @Override
        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.type.ordinal());
        }
    }

    public static enum FootType {
        WALL,
        SMALL,
        FULL;

    }
}

