/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.recipe.machine;

import ic2.api.recipe.RecipeOutput;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3i;

public class MachineOutput {
    public static final int defaultColor = Color.gray.getRGB();
    public static final Vec3i aboveOutput = new Vec3i(60, 5, defaultColor);
    public static final Vec3i aboveOutputLeft = new Vec3i(30, 5, defaultColor);
    public static final Vec3i belowOutput = new Vec3i(60, 43, defaultColor);
    public static final Vec3i belowOutputLeft = new Vec3i(30, 43, defaultColor);
    protected NBTTagCompound metadata;
    protected List<ItemStack> items;

    public MachineOutput(NBTTagCompound meta, List<ItemStack> items) {
        assert (!items.contains(null));
        this.metadata = meta;
        this.items = new ArrayList<ItemStack>(items);
    }

    public MachineOutput(NBTTagCompound meta, ItemStack ... items) {
        this(meta, Arrays.asList(items));
    }

    public List<ItemStack> getRecipeOutput(Random rand, NBTTagCompound subData) {
        return this.items;
    }

    public List<ItemStack> getAllOutputs() {
        return this.items;
    }

    public NBTTagCompound getMetadata() {
        return this.metadata;
    }

    public float getExperienceOutput() {
        return 0.0f;
    }

    public boolean canApplyEfficiency(EfficiencyType type, EfficiencyEffect effect) {
        return false;
    }

    public void applyEfficiency(EfficiencyType type, EfficiencyEffect effect, int amount) {
    }

    public void onJEIInfo(BiConsumer<String, Vec3i> consumer) {
    }

    public MachineOutput copy() {
        return new MachineOutput(this.copyNBT(this.metadata), this.copyItems(this.items));
    }

    public boolean canOverride() {
        return true;
    }

    public MachineOutput overrideOutput(List<ItemStack> list) {
        if (!this.canOverride()) {
            return this.copy();
        }
        return new MachineOutput(this.copyNBT(this.metadata), this.copyItems(list));
    }

    public RecipeOutput toIC2Exp() {
        return new RecipeOutput(this.metadata, this.items);
    }

    protected NBTTagCompound copyNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        return nbt.func_74737_b();
    }

    protected List<ItemStack> copyItems(List<ItemStack> list) {
        ArrayList<ItemStack> newList = new ArrayList<ItemStack>(list.size());
        for (ItemStack stack : list) {
            newList.add(stack.func_77946_l());
        }
        return newList;
    }

    public static enum EfficiencyEffect {
        MainProducts,
        SubProducts,
        Experience;

    }

    public static enum EfficiencyType {
        Enchantment,
        Technology,
        Magic;


        public boolean isMagicBased() {
            return this != Technology;
        }

        public boolean isTechnicBased() {
            return this == Technology;
        }
    }
}

