/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.output;

import ic2.api.classic.tile.IStackOutput;
import ic2.core.block.base.util.output.MultiSlotOutput;
import ic2.core.block.base.util.output.SimpleStackOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;

public class IStackRegistry {
    public static final IStackRegistry INSTANCE = new IStackRegistry();
    private Map<String, IStackOutputProvider> providers = new LinkedHashMap<String, IStackOutputProvider>();

    public void init() {
        this.registerStackProvider(new IStackOutputProvider(){

            @Override
            public IStackOutput createOutput(NBTTagCompound nbt) {
                return new SimpleStackOutput(nbt);
            }

            @Override
            public String getID() {
                return "Simple Output";
            }
        });
        this.registerStackProvider(new IStackOutputProvider(){

            @Override
            public IStackOutput createOutput(NBTTagCompound nbt) {
                return new MultiSlotOutput(nbt);
            }

            @Override
            public String getID() {
                return "Multi Output";
            }
        });
    }

    public void registerStackProvider(IStackOutputProvider provider) {
        this.providers.put(provider.getID(), provider);
    }

    public NBTTagCompound saveNBT(IStackOutput output) {
        NBTTagCompound nbt = output.save();
        nbt.func_74778_a("REGISTRY", output.getID());
        return nbt;
    }

    public IStackOutput readNBT(NBTTagCompound nbt) {
        IStackOutputProvider provider = this.providers.get(nbt.func_74779_i("REGISTRY"));
        if (provider == null) {
            return null;
        }
        return provider.createOutput(nbt);
    }

    public static interface IStackOutputProvider {
        public IStackOutput createOutput(NBTTagCompound var1);

        public String getID();
    }
}

