/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.classic.crops.IMultiLayeredCrop;
import ic2.api.classic.crops.ISeedCrop;
import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.block.crop.crops.CropCardBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropDynamic
extends CropCardBase
implements IMultiLayeredCrop,
ISeedCrop {
    CropInfo info;

    public CropDynamic(CropInfo info) {
        super(info.props);
        this.info = info;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getTexturesLocation() {
        return new ArrayList<ResourceLocation>();
    }

    @Override
    public List<ResourceLocation> getLayerModelLocation(int stage) {
        return this.info.stages.get(stage).getCropTextures();
    }

    @Override
    public String getId() {
        return this.info.id;
    }

    @Override
    public int getMaxSize() {
        return this.info.stages.size();
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        ICropStage stage = this.info.stages.get(crop.getCurrentSize() - 1);
        if (stage.hasDrop()) {
            return stage.getDrop();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean doDropSeeds(ICropTile tile) {
        return this.info.stages.get(tile.getCurrentSize() - 1).hasDrop() && tile.getCustomData().func_74767_n("SeedDrop");
    }

    @Override
    public ItemStack getSeed(ICropTile tile) {
        return this.info.stages.get(tile.getCurrentSize() - 1).getSeed();
    }

    @Override
    public double dropGainChance() {
        return super.dropGainChance() * this.info.harvestChanceMod;
    }

    @Override
    public String getDiscoveredBy() {
        return this.info.discoverer;
    }

    @Override
    public String getOwner() {
        return this.info.owner;
    }

    @Override
    public String getUnlocalizedName() {
        return this.info.name;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        return this.info.stages.get(cropTile.getCurrentSize() - 1).getPoints();
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        return this.info.stages.get(crop.getCurrentSize() - 1).modify(humidity, nutrients, air);
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return this.info.optimalHarvestStage <= 1 ? super.getOptimalHarvestSize(cropTile) : this.info.optimalHarvestStage;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return this.info.stages.get(cropTile.getCurrentSize() - 1).isHarvestStage(cropTile.getCustomData().func_74767_n("SeedDrop")) || super.canBeHarvested(cropTile);
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return this.info.stages.get(cropTile.getCurrentSize() - 1).getAfterHarvestStage();
    }

    @Override
    public boolean isRedstoneSignalEmitter(ICropTile cropTile) {
        return this.getEmittedRedstoneSignal(cropTile) > 0;
    }

    @Override
    public int getEmittedRedstoneSignal(ICropTile cropTile) {
        return this.info.stages.get(cropTile.getCurrentSize() - 1).getRedstoneStrenght();
    }

    @Override
    public int getEmittedLight(ICropTile crop) {
        return this.info.stages.get(crop.getCurrentSize() - 1).getLightStrenght();
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        if (!super.canGrow(cropTile)) {
            return false;
        }
        List<ICropRequirement> requirement = this.info.stages.get(Math.max(cropTile.getCurrentSize() - 1, 0)).getRequirements();
        if (requirement == null || requirement.isEmpty()) {
            return true;
        }
        for (ICropRequirement requ : requirement) {
            if (requ.isRequirementMet(cropTile)) continue;
            return false;
        }
        return true;
    }

    public static interface ICropStage {
        public int getPoints();

        public List<ICropRequirement> getRequirements();

        public List<ResourceLocation> getCropTextures();

        public boolean isHarvestStage(boolean var1);

        public int getAfterHarvestStage();

        public boolean hasDrop();

        public ItemStack getDrop();

        public boolean isSeedable();

        public ItemStack getSeed();

        public int modify(int var1, int var2, int var3);

        public int getLightStrenght();

        public int getRedstoneStrenght();
    }

    public static interface ICropRequirement {
        public boolean isRequirementMet(ICropTile var1);
    }

    public static class CropInfo {
        public String name;
        public String discoverer;
        public String owner;
        public String id;
        public CropProperties props;
        public String[] attributes;
        public List<ICropStage> stages = new ArrayList<ICropStage>();
        public int optimalHarvestStage = -1;
        public double harvestChanceMod = 1.0;
    }
}

