/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med.container;

import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.ReactorInventory;
import ic2.core.block.machine.med.logic.ReactorLogicBase;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerButtonHandler;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerGridComp;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerPageFourComp;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerPageOneComp;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerPageThreeComp;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerPageTwoComp;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerPageZeroComp;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerReactorPageComp;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorPlannerSteamReactorPageComp;
import ic2.core.inventory.gui.components.reactorPlanner.ReactorSettingsComp;
import ic2.core.inventory.slots.SlotGhoest;
import ic2.core.platform.registry.Ic2Resources;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerReactorPlanner
extends ContainerTileComponent<TileEntityReactorPlanner> {
    public ContainerReactorPlanner(InventoryPlayer player, TileEntityReactorPlanner tile) {
        super(tile);
        this.addReactor();
        this.addComponents();
        this.addPlayerInv(player);
        this.addGuiComponents(tile);
    }

    private void addGuiComponents(TileEntityReactorPlanner planner) {
        this.addComponent(new ReactorPlannerButtonHandler(planner));
        this.addComponent(new ReactorPlannerGridComp(planner));
        this.addComponent(new ReactorPlannerPageZeroComp(planner));
        this.addComponent(new ReactorPlannerPageOneComp(planner));
        this.addComponent(new ReactorPlannerPageTwoComp(planner));
        this.addComponent(new ReactorPlannerPageThreeComp(planner));
        this.addComponent(new ReactorPlannerPageFourComp(planner));
        this.addComponent(new ReactorPlannerReactorPageComp(planner));
        this.addComponent(new ReactorPlannerSteamReactorPageComp(planner));
        this.addComponent(new ReactorSettingsComp(planner));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoaded(GuiIC2 gui) {
        gui.setMaxGuiXY(212, 212);
        gui.dissableInvName();
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.reactorPlanner;
    }

    public void clear() {
        this.field_75153_a.clear();
        this.field_75151_b.clear();
    }

    public void reset(InventoryPlayer player) {
        this.clear();
        this.addReactor();
        this.addComponents();
        this.addPlayerInv(player);
    }

    public void addReactor() {
        TileEntityReactorPlanner planner = (TileEntityReactorPlanner)this.getGuiHolder();
        ReactorInventory inv = new ReactorInventory(planner);
        int size = planner.reactorSize + 3;
        int remove = planner.reactorSize * 9;
        for (int i = 0; i < 54; ++i) {
            int x = i % 9;
            int y = i / 9;
            if (x >= size) continue;
            this.func_75146_a(new SlotPlanner(inv, i, 61 + x * 18 - remove, 21 + y * 18));
        }
    }

    public void addComponents() {
        TileEntityReactorPlanner planner = (TileEntityReactorPlanner)this.getGuiHolder();
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.func_75146_a(new SlotComponent(planner.components, x + y * 3, 216 + 18 * x, 18 + 18 * y));
            }
        }
    }

    public void addPlayerInv(InventoryPlayer player) {
        for (int j = 0; j < 9; ++j) {
            this.func_75146_a(new Slot((IInventory)player, j, 8 + j * 18, 188));
        }
    }

    @Override
    public int guiInventorySize() {
        return 15 + (((TileEntityReactorPlanner)this.getGuiHolder()).reactorSize + 3) * 9;
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        if (slotID >= this.field_75151_b.size()) {
            return;
        }
        Slot slot = this.func_75139_a(slotID);
        if (slot == null) {
            return;
        }
        slot.func_75215_d(stack);
    }

    @Nullable
    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slotId != -999) {
            TileEntityReactorPlanner planner = (TileEntityReactorPlanner)this.getGuiHolder();
            boolean client = planner.isRendering();
            Slot slot = this.func_75139_a(slotId);
            if (slot instanceof SlotComponent) {
                if (client) {
                    return ItemStack.field_190927_a;
                }
                planner.selectedSlot = slot.getSlotIndex();
                planner.getNetwork().updateTileGuiField(planner, "selectedSlot");
                return ItemStack.field_190927_a;
            }
            if (slot instanceof SlotPlanner) {
                if (client) {
                    return ItemStack.field_190927_a;
                }
                ReactorLogicBase logic = planner.getReactorLogic();
                ReactorLogicBase.IReactorPrediction predict = planner.getPrediction();
                if (dragType == 0) {
                    ItemStack stack;
                    if (logic.isValid()) {
                        predict.clear();
                        logic.reset();
                        planner.updatePrediction();
                        planner.updateReactor();
                    }
                    if (!(stack = planner.components.getStackInSlot(planner.selectedSlot).func_77946_l()).func_190926_b()) {
                        stack.func_190920_e(Math.min(stack.func_77976_d(), planner.stackSize));
                    }
                    slot.func_75215_d(stack);
                    this.func_75142_b();
                } else if (dragType == 1) {
                    if (logic.isValid()) {
                        predict.clear();
                        logic.reset();
                        planner.updatePrediction();
                        planner.updateReactor();
                    }
                    slot.func_75215_d(ItemStack.field_190927_a);
                    this.func_75142_b();
                }
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public static class SlotPlanner
    extends SlotGhoest {
        public SlotPlanner(IHasInventory inv, int index, int xPosition, int yPosition) {
            super(inv, index, xPosition, yPosition);
        }
    }

    public static class SlotComponent
    extends SlotGhoest {
        public SlotComponent(IHasInventory inv, int index, int xPosition, int yPosition) {
            super(inv, index, xPosition, yPosition);
        }
    }
}

