/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.trades;

import ic2.api.classic.trading.ITradeListener;
import ic2.api.classic.trading.ITradeManager;
import ic2.api.classic.trading.prefab.BasicItemTrade;
import ic2.api.classic.trading.providers.ITradeProvider;
import ic2.api.classic.trading.trades.ITrade;
import ic2.api.classic.trading.trades.TradeType;
import ic2.core.block.personal.trades.energy.BasicCustomEnergyTrade;
import ic2.core.block.personal.trades.fluids.BasicCustomFluidTrade;
import ic2.core.block.personal.trades.items.BasicCustomItemTrade;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLLog;

public class TradeManager
implements ITradeManager {
    Map<Class<? extends ITrade>, String> clzToID = new HashMap<Class<? extends ITrade>, String>();
    Map<String, Class<? extends ITrade>> idToClz = new HashMap<String, Class<? extends ITrade>>();
    List<ITrade> worldGenTrade = new ArrayList<ITrade>();
    Map<TradeType, Map<String, ITrade>> customTrades = new HashMap<TradeType, Map<String, ITrade>>();
    Set<ITradeListener> globalListeners = new LinkedHashSet<ITradeListener>();

    public TradeManager() {
        this.registerTrade(BasicItemTrade.class, "API-ItemTrade");
        this.registerTrade(BasicCustomItemTrade.class, "BasicItemTrade");
        this.registerTrade(BasicCustomFluidTrade.class, "BasicFluidTrade");
        this.registerTrade(BasicCustomEnergyTrade.class, "BasicEnergyTrade");
    }

    @Override
    public Class<? extends ITrade> getClassForID(String id) {
        return this.idToClz.get(id);
    }

    @Override
    public String getIDFromClass(Class<? extends ITrade> clz) {
        return this.clzToID.get(clz);
    }

    @Override
    public void registerTrade(Class<? extends ITrade> trade, String id) {
        if (this.clzToID.containsKey(trade) || this.idToClz.containsKey(id)) {
            throw new RuntimeException();
        }
        this.clzToID.put(trade, id);
        this.idToClz.put(id, trade);
    }

    @Override
    public NBTTagCompound saveTradeToNBT(ITrade trade) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (trade == null) {
            return nbt;
        }
        String id = this.clzToID.get(trade.getClass());
        if (id == null) {
            return nbt;
        }
        nbt.func_74778_a("ID", id);
        trade.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public ITrade createTradeFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        Class<? extends ITrade> clz = this.idToClz.get(nbt.func_74779_i("ID"));
        if (clz == null) {
            return null;
        }
        try {
            ITrade trade = clz.newInstance();
            trade.readFromNBT(nbt);
            return trade;
        }
        catch (Exception e) {
            FMLLog.getLogger().info("Got Invalid Trade: " + clz.getSimpleName() + ", Skipping TradeLoad");
            return null;
        }
    }

    @Override
    public void addWorldGenTrade(ITrade trade) {
        this.worldGenTrade.add(trade);
    }

    @Override
    public void addGlobalListener(ITradeListener listener) {
        this.globalListeners.add(listener);
    }

    @Override
    public void onTraderCreated(ITradeProvider prov) {
        for (ITradeListener listener : this.globalListeners) {
            prov.addListener(listener);
            listener.onListenCreated(prov);
        }
    }

    @Override
    public List<ITrade> getWorldGenTrades() {
        return this.worldGenTrade;
    }

    @Override
    public void registerCustomTrade(ITrade trade, String id) {
        if (trade == null) {
            return;
        }
        TradeType type = trade.getType();
        if (type == null) {
            return;
        }
        Map<String, ITrade> tradeMap = this.customTrades.get((Object)type);
        if (tradeMap == null) {
            tradeMap = new HashMap<String, ITrade>();
            this.customTrades.put(type, tradeMap);
        }
        tradeMap.put(id, trade);
    }

    @Override
    public Map<String, ITrade> getCustomTrades(TradeType type) {
        Map<String, ITrade> tradeMap = this.customTrades.get((Object)type);
        if (tradeMap == null) {
            tradeMap = new HashMap<String, ITrade>();
        }
        return tradeMap;
    }
}

