/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.comparator.ComparatorManager;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityAdvComparator
extends TileEntityBlock {
    @NetworkField(index=3)
    public EnumFacing rotation = EnumFacing.NORTH;
    public byte outputStrength = 0;
    @NetworkField(index=4)
    public BlockRedstoneComparator.Mode mode = BlockRedstoneComparator.Mode.COMPARE;

    public TileEntityAdvComparator() {
        this.addNetworkFields("rotation", "mode");
    }

    @Override
    public ComparatorManager getManager() {
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        this.rotation = EnumFacing.func_82600_a((int)nbt.func_74771_c("Rotation"));
        this.mode = this.getMode(nbt.func_74771_c("Mode"));
        this.outputStrength = nbt.func_74771_c("Output");
        super.func_145839_a(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74774_a("Rotation", (byte)this.rotation.func_176745_a());
        nbt.func_74774_a("Mode", (byte)this.mode.ordinal());
        nbt.func_74774_a("Output", this.outputStrength);
        return nbt;
    }

    private BlockRedstoneComparator.Mode getMode(int id) {
        BlockRedstoneComparator.Mode[] values = BlockRedstoneComparator.Mode.values();
        if (id >= values.length || id < 0) {
            return BlockRedstoneComparator.Mode.COMPARE;
        }
        return values[id];
    }

    public void setFacing(EnumFacing face, float xOffset, float yOffset, float zOffset) {
        super.setFacing(face);
        this.rotation = TileEntityAdvComparator.getDefaultForAxis(face.func_176740_k(), xOffset, yOffset, zOffset);
        this.getNetwork().updateTileEntityField(this, "rotation");
    }

    @Override
    public void setFacing(EnumFacing face) {
        super.setFacing(face);
        this.rotation = TileEntityAdvComparator.getDefaultForAxis(face.func_176740_k());
        this.getNetwork().updateTileEntityField(this, "rotation");
    }

    public void setMode(BlockRedstoneComparator.Mode mode) {
        this.mode = mode;
        this.getNetwork().updateTileEntityField(this, "mode");
    }

    public BlockRedstoneComparator.Mode getMode() {
        return this.mode;
    }

    public static EnumFacing getDefaultForAxis(EnumFacing.Axis side, float x, float y, float z) {
        switch (side) {
            case X: {
                return !TileEntityAdvComparator.getDifference(y, z) ? (y > 0.5f ? EnumFacing.DOWN : EnumFacing.UP) : (z > 0.5f ? EnumFacing.NORTH : EnumFacing.SOUTH);
            }
            case Y: {
                return !TileEntityAdvComparator.getDifference(x, z) ? (x > 0.5f ? EnumFacing.WEST : EnumFacing.EAST) : (z > 0.5f ? EnumFacing.NORTH : EnumFacing.SOUTH);
            }
            case Z: {
                return !TileEntityAdvComparator.getDifference(y, x) ? (y > 0.5f ? EnumFacing.DOWN : EnumFacing.UP) : (x > 0.5f ? EnumFacing.WEST : EnumFacing.EAST);
            }
        }
        return EnumFacing.NORTH;
    }

    public static boolean getDifference(float x, float y) {
        if (x < 0.5f) {
            if (y >= 0.5f) {
                return 1.0f - y < x;
            }
            return y < x;
        }
        if (y < 0.5f) {
            return 1.0f - y > x;
        }
        return y > x;
    }

    public static EnumFacing getDefaultForAxis(EnumFacing.Axis side) {
        switch (side) {
            case X: {
                return EnumFacing.UP;
            }
            case Y: {
                return EnumFacing.NORTH;
            }
            case Z: {
                return EnumFacing.UP;
            }
        }
        return EnumFacing.NORTH;
    }

    public EnumFacing.Axis getAxis() {
        return this.getFacing().func_176740_k();
    }

    public EnumFacing getSide() {
        return this.rotation;
    }

    public void rotate() {
        this.rotation = this.rotation.func_176732_a(this.getAxis());
        this.getNetwork().updateTileEntityField(this, "rotation");
    }

    public byte getOutputStrength() {
        return this.outputStrength;
    }

    public void setOutputStrength(byte outputStrength) {
        this.outputStrength = outputStrength;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("rotation") || field.equals("mode")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
        super.onNetworkUpdate(field);
    }
}

