/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.entity.explosion;

import ic2.core.IC2;
import ic2.core.entity.explosion.PointExplosion;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDynamite
extends Entity
implements IProjectile {
    private static final DataParameter<ItemStack> itemToRender = EntityDataManager.func_187226_a(EntityDynamite.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Boolean> isStuck = EntityDataManager.func_187226_a(EntityDynamite.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> sticky = EntityDataManager.func_187226_a(EntityDynamite.class, (DataSerializer)DataSerializers.field_187198_h);
    public BlockPos stuckPos;
    public int fuse = 100;
    private int ticksInGround = 0;
    private int ticksInAir = 0;

    public EntityDynamite(World world, double x, double y, double z) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
    }

    public EntityDynamite(World world, double x, double y, double z, boolean sticky) {
        this(world, x, y, z);
        this.setSticky(sticky);
    }

    public EntityDynamite(World worldIn) {
        this(worldIn, 0.0, 0.0, 0.0);
    }

    public EntityDynamite setRenderer(ItemStack render) {
        this.field_70180_af.func_187227_b(itemToRender, (Object)render);
        return this;
    }

    public EntityDynamite(World world, EntityLivingBase entityliving) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(entityliving.field_70165_t, entityliving.field_70163_u + (double)entityliving.func_70047_e(), entityliving.field_70161_v, entityliving.field_70177_z, entityliving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.field_70163_u -= 0.1000000014901161;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * 3.141593f)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * 3.141593f));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.0f, 1.0f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(itemToRender, (Object)Ic2Items.dynamite.func_77946_l());
        this.field_70180_af.func_187214_a(isStuck, (Object)false);
        this.field_70180_af.func_187214_a(sticky, (Object)false);
    }

    protected void func_70037_a(NBTTagCompound tagCompund) {
        this.setStuck(tagCompund.func_74767_n("InGround"));
    }

    protected void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("InGround", this.isStuck());
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float n2;
        float n;
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = n = (float)(Math.atan2(x, z) * 180.0 / 3.141592741012573);
        this.field_70126_B = n;
        this.field_70125_A = n2 = (float)(Math.atan2(y, f3) * 180.0 / 3.141592741012573);
        this.field_70127_C = n2;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float n2;
            float n;
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70177_z = n = (float)(Math.atan2(x, z) * 180.0 / 3.141592741012573);
            this.field_70126_B = n;
            this.field_70125_A = n2 = (float)(Math.atan2(y, f) * 180.0 / 3.141592741012573);
            this.field_70127_C = n2;
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float n2;
            float n;
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = n = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.141592741012573);
            this.field_70126_B = n;
            this.field_70125_A = n2 = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / 3.141592741012573);
            this.field_70127_C = n2;
        }
        boolean server = IC2.platform.isSimulating();
        if (this.fuse-- <= 0) {
            if (server) {
                this.func_70106_y();
                this.explode();
            } else {
                this.func_70106_y();
            }
        } else if (this.fuse < 100 && this.fuse % 2 == 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.isStuck()) {
            ++this.ticksInGround;
            if (this.ticksInGround >= 200) {
                this.func_70106_y();
            }
            if (this.isSticky()) {
                this.fuse -= 3;
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (!server) {
                    return;
                }
                if (this.stuckPos != null) {
                    if (this.field_70170_p.func_180495_p(this.stuckPos).func_177230_c() != Blocks.field_150350_a) {
                        return;
                    }
                    this.stuckPos = null;
                }
                this.setStuck(false);
            }
        }
        ++this.ticksInAir;
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raceTrace = this.field_70170_p.func_147447_a(vec3d, vec3d2, false, true, false);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d2 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raceTrace != null) {
            vec3d2 = new Vec3d(raceTrace.field_72307_f.field_72450_a, raceTrace.field_72307_f.field_72448_b, raceTrace.field_72307_f.field_72449_c);
            float remainX = (float)(raceTrace.field_72307_f.field_72450_a - this.field_70165_t);
            float remainY = (float)(raceTrace.field_72307_f.field_72448_b - this.field_70163_u);
            float remainZ = (float)(raceTrace.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76129_c((float)(remainX * remainX + remainY * remainY + remainZ * remainZ));
            this.stuckPos = raceTrace.func_178782_a().func_185334_h();
            this.field_70165_t -= (double)(remainX / f2) * 0.0500000007450581;
            this.field_70163_u -= (double)(remainY / f2) * 0.0500000007450581;
            this.field_70161_v -= (double)(remainZ / f2) * 0.0500000007450581;
            this.field_70165_t += (double)remainX;
            this.field_70163_u += (double)remainY;
            this.field_70161_v += (double)remainZ;
            this.field_70159_w *= (double)(0.75f - this.field_70146_Z.nextFloat());
            this.field_70181_x *= -0.300000011920929;
            this.field_70179_y *= (double)(0.75f - this.field_70146_Z.nextFloat());
            this.setStuck(true);
        } else {
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.setStuck(false);
        }
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / 3.141592741012573);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / 3.141592741012573);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f4 = 0.98f;
        float f5 = 0.04f;
        if (this.func_70090_H()) {
            this.fuse += 2000;
            for (int i1 = 0; i1 < 4; ++i1) {
                float f6 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f6, this.field_70163_u - this.field_70181_x * (double)f6, this.field_70161_v - this.field_70179_y * (double)f6, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f4 = 0.75f;
        }
        this.field_70159_w *= (double)f4;
        this.field_70181_x *= (double)f4;
        this.field_70179_y *= (double)f4;
        this.field_70181_x -= (double)f5;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void explode() {
        PointExplosion explosion = new PointExplosion(this.field_70170_p, null, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 1.0f, 1.0f, 0.8f);
        explosion.doExplosionA(1, 1, 1, 1, 1, 1);
        explosion.doExplosionB(true);
    }

    public ItemStack getStack() {
        ItemStack result = (ItemStack)this.field_70180_af.func_187225_a(itemToRender);
        if (result.func_190926_b()) {
            result = Ic2Items.dynamite.func_77946_l();
        }
        return result;
    }

    public boolean isStuck() {
        return (Boolean)this.field_70180_af.func_187225_a(isStuck);
    }

    public void setStuck(boolean stuck) {
        this.field_70180_af.func_187227_b(isStuck, (Object)stuck);
    }

    public boolean isSticky() {
        return (Boolean)this.field_70180_af.func_187225_a(sticky);
    }

    public void setSticky(boolean value) {
        this.field_70180_af.func_187227_b(sticky, (Object)value);
    }
}

