/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.fluid;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerSteamReactor
implements IFluidHandler {
    FluidTank water;
    FluidTank steam;
    IFluidTankProperties[] props;

    public FluidHandlerSteamReactor(FluidTank first, FluidTank second) {
        this.water = first;
        this.steam = second;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.props == null) {
            ArrayList<IFluidTankProperties> propList = new ArrayList<IFluidTankProperties>();
            propList.addAll(Arrays.asList(this.water.getTankProperties()));
            propList.addAll(Arrays.asList(this.steam.getTankProperties()));
            this.props = propList.toArray(new IFluidTankProperties[propList.size()]);
        }
        return this.props;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource.getFluid() != FluidRegistry.WATER) {
            return 0;
        }
        return this.water.fill(resource, doFill);
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.steam.drain(resource, doDrain);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.steam.drain(maxDrain, doDrain);
    }
}

