/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.special;

import ic2.api.classic.tile.ITeleporterTarget;
import ic2.core.block.machine.high.TileEntityTeleporterHub;
import ic2.core.inventory.container.ContainerComponent;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.buttons.IC2Button;
import ic2.core.inventory.gui.buttons.IconButton;
import ic2.core.inventory.gui.buttons.ToggleButton;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.network.fieldEvents.custom.NBTFieldPacket;
import ic2.core.platform.lang.components.special.DisplayLocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.TupleData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class TeleportingHubComp
extends GuiComponent {
    TileEntityTeleporterHub hub;
    int offset = 0;
    ITeleporterTarget.TeleporterTarget tele;
    @SideOnly(value=Side.CLIENT)
    GuiTextField textField;
    boolean wasPressed = false;
    TupleData<ITeleporterTarget.TeleporterTarget, String> toRename = new TupleData();

    public TeleportingHubComp(TileEntityTeleporterHub tile) {
        super(Ic2GuiComp.nullBox);
        this.hub = tile;
        this.tele = new ITeleporterTarget.TeleporterTarget(tile);
    }

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.KeyPressed, GuiComponent.ActionRequest.FrontgroundDraw, GuiComponent.ActionRequest.PostDraw, GuiComponent.ActionRequest.ButtonNotify, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.GuiTick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawFrontground(GuiIC2 gui, int mouseX, int mouseY) {
        int realIndex;
        List<Tuple<ITeleporterTarget.TeleporterTarget, String>> list = this.hub.targets.getTargets();
        for (int i = 0; i < 6 && (realIndex = this.offset + i) < list.size(); ++i) {
            gui.drawString((String)list.get(realIndex).func_76340_b(), 23, 22 + 19 * i, 0x404040);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiInit(GuiIC2 gui) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        boolean ctrl = gui.func_146271_m();
        for (int i = 0; i < 6; ++i) {
            gui.registerButton(new IconButton(i, x + 5, y + 16 + i * 19, 20, 20).setItemStack(Ic2Items.displayIcons[1].func_77946_l()).setIconOnly());
            gui.registerButton(new IC2Button(10 + i, x + 118, y + 18 + i * 19, 50, 16, ctrl ? Ic2GuiLang.teleporterRename : Ic2GuiLang.teleporterTeleport));
        }
        gui.registerButton(new IC2Button(20, x + 150, y + 6, 20, 9, "-"));
        gui.registerButton(new IC2Button(21, x + 150, y + 132, 20, 9, "+"));
        gui.registerButton(new ToggleButton(22, x - 14, y + 144, 20, 20).setIcons(Ic2Items.displayIcons[1], Ic2Items.displayIcons[0]).addToolTip(new DisplayLocaleComp("Set is Custom Name")));
        gui.registerButton(new IC2Button(23, x + 90, y + 132, 50, 9, Ic2GuiLang.teleporterRename));
        this.textField = new GuiTextField(0, gui.field_146297_k.field_71466_p, 8, 144, 158, 20);
        this.textField.func_146203_f(19);
        if (this.toRename.hasKey()) {
            this.textField.func_146180_a(this.toRename.getValue());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void postDraw(GuiIC2 gui, int mouseX, int mouseY) {
        int amount;
        if (this.toRename.hasKey()) {
            GlStateManager.func_179109_b((float)gui.getXOffset(), (float)gui.getYOffset(), (float)1000.0f);
            this.textField.func_146195_b(true);
            this.textField.func_146194_f();
            GlStateManager.func_179109_b((float)(-gui.getXOffset()), (float)(-gui.getYOffset()), (float)-1000.0f);
        }
        if (mouseX >= 5 && mouseX <= 169 && mouseY >= 16 && mouseY <= 131 && (double)(amount = Mouse.getDWheel()) != 0.0) {
            int result = -(amount / 120);
            this.offset = Math.max(0, Math.min(this.offset + result, this.hub.targets.getTargets().size() - 1));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiTick(GuiIC2 gui) {
        boolean isPressed = gui.func_146271_m();
        if (this.wasPressed != isPressed) {
            int id;
            this.wasPressed = isPressed;
            for (int i = 0; i < 6 && gui.hasButton(id = i + 10); ++i) {
                gui.getCastedButton(id, IC2Button.class).setName(isPressed ? Ic2GuiLang.teleporterRename : Ic2GuiLang.teleporterTeleport);
            }
        }
        ToggleButton button = gui.getCastedButton(22, ToggleButton.class);
        boolean bl = button.field_146125_m = this.toRename.hasKey() && !this.toRename.getKey().equals(this.tele);
        if (button.field_146125_m) {
            button.setState(this.toRename.getKey().isCustom);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onButtonClick(GuiIC2 gui, GuiButton button) {
        int id = button.field_146127_k;
        if (this.toRename.hasKey()) {
            if (id == 22) {
                this.toRename.getKey().isCustom = !this.toRename.getKey().isCustom;
            }
            return;
        }
        if (id == 20) {
            if (this.offset > 0) {
                --this.offset;
            }
        } else if (id == 21) {
            this.offset = this.offset + 1 < this.hub.targets.getTargets().size() ? ++this.offset : Math.max(0, this.hub.targets.getTargets().size() - 1);
        } else if (id == 23) {
            this.toRename.setData(this.tele, gui.getGuiName());
        } else if (id >= 0 && id < 6) {
            int index = id + this.offset;
            List<Tuple<ITeleporterTarget.TeleporterTarget, String>> list = this.hub.targets.getTargets();
            if (index < list.size()) {
                NBTTagCompound nbt = ((ITeleporterTarget.TeleporterTarget)list.get(index).func_76341_a()).writeToNBT();
                nbt.func_74757_a("Delete", true);
                this.hub.getNetwork().initiateCustomClientTileEntityEvent(this.hub, new NBTFieldPacket(nbt));
            }
        } else if (id >= 10 && id < 16) {
            if (gui.func_146271_m()) {
                int index = id - 10 + this.offset;
                List<Tuple<ITeleporterTarget.TeleporterTarget, String>> list = this.hub.targets.getTargets();
                if (index < list.size()) {
                    Tuple<ITeleporterTarget.TeleporterTarget, String> entry = list.get(index);
                    this.toRename.setData((ITeleporterTarget.TeleporterTarget)entry.func_76341_a(), (String)entry.func_76340_b());
                    this.textField.func_146180_a((String)entry.func_76340_b());
                }
            } else {
                int index = id - 10 + this.offset;
                List<Tuple<ITeleporterTarget.TeleporterTarget, String>> list = this.hub.targets.getTargets();
                if (index < list.size()) {
                    NBTTagCompound nbt = ((ITeleporterTarget.TeleporterTarget)list.get(index).func_76341_a()).writeToNBT();
                    nbt.func_74757_a("Teleport", true);
                    this.hub.getNetwork().initiateCustomClientTileEntityEvent(this.hub, new NBTFieldPacket(nbt));
                    gui.getPlayer().func_71053_j();
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyTyped(GuiIC2 gui, char keyTyped, int keyCode) {
        if (this.toRename.hasKey()) {
            if (keyCode == 1) {
                this.toRename.clear();
                return true;
            }
            if (keyCode == 28) {
                NBTTagCompound nbt = this.toRename.getKey().writeToNBT();
                nbt.func_74778_a("Name", this.textField.func_146179_b());
                this.hub.getNetwork().initiateCustomClientTileEntityEvent(this.hub, new NBTFieldPacket(nbt));
                if (this.toRename.getKey().equals(this.tele)) {
                    this.hub.setCustomName(this.textField.func_146179_b());
                    gui.setGuiName(gui.getContainer(ContainerComponent.class).getGuiName());
                }
                this.toRename.clear();
                return true;
            }
            this.textField.func_146201_a(keyTyped, keyCode);
            this.toRename.setData(this.toRename.getKey(), this.textField.func_146179_b());
            return true;
        }
        return false;
    }
}

