/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades;

import ic2.api.classic.network.ICustomNetworkItemEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.IInventoryModifier;
import ic2.core.item.base.ItemIC2;
import ic2.core.item.upgrades.subtypes.inventory.AccessUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.AutomationUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.IMetaInventoryUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.ItemLimitUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.RedstoneDeconductorUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.RotationDissablerUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.SlotAccessModifierUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.SlotDiversityUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.SlotSideModifierUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.SlotTypeModifier;
import ic2.core.item.upgrades.subtypes.inventory.StackDiversityUpgrade;
import ic2.core.item.upgrades.subtypes.inventory.StackLimiterUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInventoryUpgrades
extends ItemIC2
implements IInventoryModifier,
IBootable,
IHandHeldInventory,
ICustomNetworkItemEventListener {
    Map<Integer, IMetaInventoryUpgrade> upgrades = new HashMap<Integer, IMetaInventoryUpgrade>();

    public ItemInventoryUpgrades() {
        this.func_77627_a(true);
        this.setUnlocalizedName(Ic2ItemLang.inventoryUpgradeBase);
        this.func_77625_d(64);
    }

    @Override
    public void onLoad() {
        this.upgrades.put(0, new AutomationUpgrade());
        this.upgrades.put(1, new AccessUpgrade());
        this.upgrades.put(2, new RotationDissablerUpgrade());
        this.upgrades.put(3, new SlotTypeModifier());
        this.upgrades.put(4, new SlotAccessModifierUpgrade());
        this.upgrades.put(5, new SlotSideModifierUpgrade());
        this.upgrades.put(6, new RedstoneDeconductorUpgrade());
        this.upgrades.put(7, new SlotDiversityUpgrade());
        this.upgrades.put(8, new StackDiversityUpgrade());
        this.upgrades.put(9, new ItemLimitUpgrade());
        this.upgrades.put(10, new StackLimiterUpgrade());
        Ic2Items.automationUpgrade = new ItemStack((Item)this, 1, 0);
        Ic2Items.sideAccessUpgrade = new ItemStack((Item)this, 1, 1);
        Ic2Items.rotationDissablerUpgrade = new ItemStack((Item)this, 1, 2);
        Ic2Items.slotTypeModifierUpgrade = new ItemStack((Item)this, 1, 3);
        Ic2Items.slotAccessModifierUpgrade = new ItemStack((Item)this, 1, 4);
        Ic2Items.slotSideUpgrade = new ItemStack((Item)this, 1, 5);
        Ic2Items.redstoneDeconductorUpgrade = new ItemStack((Item)this, 1, 6);
        Ic2Items.slotDiversityUpgrade = new ItemStack((Item)this, 1, 7);
        Ic2Items.stackDiversityUpgrade = new ItemStack((Item)this, 1, 8);
        Ic2Items.itemLimiterUpgrade = new ItemStack((Item)this, 1, 9);
        Ic2Items.stackLimiterUpgrade = new ItemStack((Item)this, 1, 10);
    }

    @Override
    public void onInstalling(ItemStack stack, IHasHandler.IInventoryHandler handler) {
        IMetaInventoryUpgrade upgrade = this.upgrades.get(stack.func_77960_j());
        if (upgrade != null) {
            upgrade.onInstalling(stack, handler);
        }
    }

    @Override
    public IInventoryModifier.EffectType getType(ItemStack stack) {
        IMetaInventoryUpgrade upgrade = this.upgrades.get(stack.func_77960_j());
        if (upgrade != null) {
            return upgrade.getEffect();
        }
        return IInventoryModifier.EffectType.Slot;
    }

    @Override
    public List<Integer> getValidVariants() {
        return this.getSortedList();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        IMetaInventoryUpgrade upgrade = this.upgrades.get(meta);
        if (upgrade == null) {
            return null;
        }
        return upgrade.getSprite();
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        IMetaInventoryUpgrade upgrade = this.upgrades.get(stack.func_77960_j());
        if (upgrade != null) {
            return upgrade.getName();
        }
        return super.getLangComponent(stack);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 58;
    }

    public List<Integer> getSortedList() {
        ArrayList<Integer> list = new ArrayList<Integer>(this.upgrades.keySet());
        Collections.sort(list);
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        IMetaInventoryUpgrade upgrade = this.upgrades.get(stack.func_77960_j());
        if (upgrade != null) {
            upgrade.addInformation(stack, player, tooltip, debugTooltip, sortedTooltip);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        IMetaInventoryUpgrade upgrade = this.upgrades.get(stack.func_77960_j());
        if (upgrade != null && upgrade.hasRightClick()) {
            return upgrade.onRightClick(stack, worldIn, playerIn, handIn);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        IMetaInventoryUpgrade upgrade = this.upgrades.get(stack.func_77960_j());
        if (upgrade != null && upgrade.hasBlockClick()) {
            return upgrade.onBlockClick(stack, world, pos, side, player, hand);
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        IMetaInventoryUpgrade upgrade = this.upgrades.get(stack.func_77960_j());
        if (upgrade instanceof IHandHeldInventory) {
            return ((IHandHeldInventory)((Object)upgrade)).getInventory(player, hand, stack);
        }
        return null;
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (Integer meta : this.getSortedList()) {
            items.add((Object)new ItemStack((Item)this, 1, meta.intValue()));
        }
    }

    @Override
    public void onNetworkEvent(ItemStack stack, EntityPlayer player, INetworkFieldData data) {
        IMetaInventoryUpgrade upgrade = this.upgrades.get(stack.func_77960_j());
        if (upgrade == null) {
            return;
        }
        upgrade.onNetworkEvent(stack, player, data);
    }
}

