/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.config.ConfigHandler;
import me.desht.pneumaticcraft.common.item.ItemGunAmmo;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGunAmmoStandard
extends ItemGunAmmo {
    private static final String NBT_POTION = "potion";

    public ItemGunAmmoStandard() {
        super("gun_ammo");
    }

    @Override
    protected int getCartridgeSize() {
        return ConfigHandler.minigun.standardAmmoCartridgeSize;
    }

    @Nonnull
    private static ItemStack getPotion(ItemStack ammo) {
        if (ammo.func_77978_p() != null && ammo.func_77978_p().func_74764_b(NBT_POTION)) {
            return new ItemStack(ammo.func_77978_p().func_74775_l(NBT_POTION));
        }
        return ItemStack.field_190927_a;
    }

    public static void setPotion(ItemStack ammo, ItemStack potion) {
        NBTTagCompound tag = new NBTTagCompound();
        potion.func_77955_b(tag);
        NBTUtil.setCompoundTag(ammo, NBT_POTION, (NBTBase)tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            super.func_150895_a(tab, list);
            NonNullList potions = NonNullList.func_191196_a();
            Items.field_151068_bn.func_150895_a(tab, potions);
            for (ItemStack potion : potions) {
                ItemStack ammo = new ItemStack((Item)this);
                ItemGunAmmoStandard.setPotion(ammo, potion);
                list.add((Object)ammo);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_POTION);
    }

    @Override
    public int getAmmoCost(ItemStack ammoStack) {
        ItemStack potion = ItemGunAmmoStandard.getPotion(ammoStack);
        return potion.func_190926_b() ? 1 : ItemGunAmmoStandard.getPotionAmmoCost(potion.func_77973_b());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getAmmoColor(ItemStack ammo) {
        ItemStack potion = ItemGunAmmoStandard.getPotion(ammo);
        return potion.func_190926_b() ? 0xFFFF00 : Minecraft.func_71410_x().getItemColors().func_186728_a(potion, 0);
    }

    @Override
    public float getAirUsageMultiplier(Minigun minigun, ItemStack ammoStack) {
        if (minigun.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) > 0 && !ItemGunAmmoStandard.getPotion(ammoStack).func_190926_b()) {
            return (float)minigun.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) + 1.0f;
        }
        return 1.0f;
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> infoList, ITooltipFlag extraInfo) {
        super.func_77624_a(stack, world, infoList, extraInfo);
        ItemStack potion = ItemGunAmmoStandard.getPotion(stack);
        if (!potion.func_190926_b()) {
            ArrayList potionInfo = new ArrayList();
            potion.func_77973_b().func_77624_a(potion, world, potionInfo, extraInfo);
            String extra = "";
            if (potion.func_77973_b() instanceof ItemSplashPotion) {
                extra = " " + I18n.func_135052_a((String)"gui.tooltip.gunAmmo.splash", (Object[])new Object[0]);
            } else if (potion.func_77973_b() instanceof ItemLingeringPotion) {
                extra = " " + I18n.func_135052_a((String)"gui.tooltip.gunAmmo.lingering", (Object[])new Object[0]);
            }
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.gunAmmo", (Object[])new Object[0]) + " " + (String)potionInfo.get(0) + extra);
        } else {
            infoList.add(I18n.func_135052_a((String)"gui.tooltip.gunAmmo.combineWithPotion", (Object[])new Object[0]));
        }
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        ItemStack potion = ItemGunAmmoStandard.getPotion(ammo);
        if (!potion.func_190926_b() && target instanceof EntityLivingBase) {
            EntityPlayer shooter = minigun.getPlayer();
            if (minigun.dispenserWeightedPercentage(ConfigHandler.minigun.potionProcChance, 0.25f)) {
                if (potion.func_77973_b() == Items.field_151068_bn) {
                    List effects = PotionUtils.func_185189_a((ItemStack)potion);
                    for (PotionEffect effect : effects) {
                        ((EntityLivingBase)target).func_70690_d(new PotionEffect(effect));
                    }
                    NetworkHandler.sendToAllAround(new PacketPlaySound(SoundEvents.field_187825_fO, SoundCategory.PLAYERS, target.field_70165_t, target.field_70163_u, target.field_70161_v, 1.0f, 1.0f, true), target.field_70170_p);
                } else if (potion.func_77973_b() == Items.field_185155_bH || potion.func_77973_b() == Items.field_185156_bI) {
                    EntityPotion entityPotion = new EntityPotion(shooter.field_70170_p, (EntityLivingBase)shooter, potion);
                    entityPotion.func_70107_b(target.field_70165_t, target.field_70163_u, target.field_70161_v);
                    shooter.field_70170_p.func_72838_d((Entity)entityPotion);
                }
            }
            return ItemGunAmmoStandard.getPotionAmmoCost(potion.func_77973_b());
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockPos pos, EnumFacing face, Vec3d hitVec) {
        ItemStack potion = ItemGunAmmoStandard.getPotion(ammo);
        if (potion.func_77973_b() == Items.field_185155_bH || potion.func_77973_b() == Items.field_185156_bI) {
            EntityPlayer shooter = minigun.getPlayer();
            int chance = ConfigHandler.minigun.potionProcChance + minigun.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER) * 2;
            if (shooter.field_70170_p.field_73012_v.nextInt(100) < chance) {
                EntityPotion entityPotion = new EntityPotion(shooter.field_70170_p, (EntityLivingBase)shooter, potion);
                BlockPos pos2 = pos.func_177972_a(face);
                entityPotion.func_70107_b((double)pos2.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)pos2.func_177952_p() + 0.5);
                shooter.field_70170_p.func_72838_d((Entity)entityPotion);
            }
            return ItemGunAmmoStandard.getPotionAmmoCost(potion.func_77973_b());
        }
        return super.onBlockHit(minigun, ammo, pos, face, hitVec);
    }

    private static int getPotionAmmoCost(Item item) {
        if (item == Items.field_185156_bI) {
            return 6;
        }
        if (item == Items.field_185155_bH) {
            return 3;
        }
        if (item == Items.field_151068_bn) {
            return 1;
        }
        throw new IllegalArgumentException("Item " + item + " is not a potion!");
    }
}

