/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.util.NBTUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketUpdateArmorExtraData
extends AbstractPacket<PacketUpdateArmorExtraData> {
    private static final List<Map<String, Integer>> VALID_KEYS = new ArrayList<Map<String, Integer>>();
    private EntityEquipmentSlot slot;
    private NBTTagCompound data;

    private static void addKey(EntityEquipmentSlot slot, String key, int nbtType) {
        VALID_KEYS.get(slot.func_188454_b()).put(key, nbtType);
    }

    public PacketUpdateArmorExtraData() {
    }

    public PacketUpdateArmorExtraData(EntityEquipmentSlot slot, NBTTagCompound data) {
        this.slot = slot;
        this.data = data;
    }

    @Override
    public void handleClientSide(PacketUpdateArmorExtraData message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketUpdateArmorExtraData message, EntityPlayer player) {
        ItemStack stack = player.func_184582_a(message.slot);
        if (stack.func_77973_b() instanceof ItemPneumaticArmor) {
            CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
            NBTUtil.initNBTTagCompound(stack);
            for (String key : message.data.func_150296_c()) {
                NBTBase dataTag;
                if (!PacketUpdateArmorExtraData.isKeyOKForSlot(key, message.slot, (dataTag = message.data.func_74781_a(key)).func_74732_a())) continue;
                stack.func_77978_p().func_74782_a(key, dataTag);
                handler.onDataFieldUpdated(message.slot, key, dataTag);
            }
        }
    }

    private static boolean isKeyOKForSlot(String key, EntityEquipmentSlot slot, int nbtType) {
        return VALID_KEYS.get(slot.func_188454_b()).get(key) == nbtType;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = EntityEquipmentSlot.values()[buf.readByte()];
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.slot.ordinal());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    static {
        Arrays.stream(EntityEquipmentSlot.values()).filter(slot -> slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR).map(slot -> new HashMap()).forEach(VALID_KEYS::add);
        PacketUpdateArmorExtraData.addKey(EntityEquipmentSlot.HEAD, "entityFilter", 8);
        PacketUpdateArmorExtraData.addKey(EntityEquipmentSlot.LEGS, "speedBoost", 3);
        PacketUpdateArmorExtraData.addKey(EntityEquipmentSlot.LEGS, "jumpBoost", 3);
        PacketUpdateArmorExtraData.addKey(EntityEquipmentSlot.FEET, "JetBootsBuilderMode", 1);
    }
}

