/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IHeatExchanger;
import me.desht.pneumaticcraft.common.heat.HeatUtil;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.tileentity.IHeatTinted;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;

public class TileEntityVortexTube
extends TileEntityPneumaticBase
implements IHeatExchanger,
IHeatTinted {
    private final IHeatExchangerLogic coldHeatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    private final IHeatExchangerLogic hotHeatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    private final IHeatExchangerLogic connectingExchanger = PneumaticRegistry.getInstance().getHeatRegistry().getHeatExchangerLogic();
    private int visualizationTimer = 30;
    @DescSynced
    public final boolean[] sidesConnected = new boolean[6];
    @DescSynced
    private boolean visualize;
    @DescSynced
    private int coldHeatLevel = 10;
    @DescSynced
    private int hotHeatLevel = 10;

    public TileEntityVortexTube() {
        super(20.0f, 25.0f, 2000, 0);
        this.coldHeatExchanger.setThermalResistance(0.01);
        this.hotHeatExchanger.setThermalResistance(0.01);
        this.connectingExchanger.setThermalResistance(100.0);
        this.connectingExchanger.addConnectedExchanger(this.coldHeatExchanger);
        this.connectingExchanger.addConnectedExchanger(this.hotHeatExchanger);
    }

    @Override
    public IHeatExchangerLogic getHeatExchangerLogic(EnumFacing side) {
        if (side == null || side == this.getRotation().func_176734_d()) {
            return this.hotHeatExchanger;
        }
        if (side == this.getRotation()) {
            return this.coldHeatExchanger;
        }
        return null;
    }

    @Override
    protected EnumFacing[] getConnectedHeatExchangerSides() {
        return new EnumFacing[]{this.getRotation().func_176734_d()};
    }

    @Override
    protected void initializeIfHeatExchanger() {
        super.initializeIfHeatExchanger();
        this.initializeHeatExchanger(this.coldHeatExchanger, this.getRotation());
    }

    @Override
    public boolean isConnectedTo(EnumFacing side) {
        return side != this.getRotation() && side != this.getRotation().func_176734_d();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound coldHeatTag = new NBTTagCompound();
        this.coldHeatExchanger.writeToNBT(coldHeatTag);
        tag.func_74782_a("coldHeat", (NBTBase)coldHeatTag);
        for (int i = 0; i < 6; ++i) {
            tag.func_74757_a("sideConnected" + i, this.sidesConnected[i]);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.coldHeatExchanger.readFromNBT(tag.func_74775_l("coldHeat"));
        for (int i = 0; i < 6; ++i) {
            this.sidesConnected[i] = tag.func_74767_n("sideConnected" + i);
        }
    }

    public int getColdHeatLevel() {
        return this.visualize ? 0 : this.coldHeatLevel;
    }

    public int getHotHeatLevel() {
        return this.visualize ? 20 : this.hotHeatLevel;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            this.connectingExchanger.update();
            this.coldHeatExchanger.update();
            int usedAir = (int)(this.getPressure() * 10.0f);
            if (usedAir > 0) {
                this.addAir(-usedAir);
                double generatedHeat = (double)usedAir / 10.0;
                this.coldHeatExchanger.addHeat(-generatedHeat);
                this.hotHeatExchanger.addHeat(generatedHeat);
            }
            boolean bl = this.visualize = this.visualizationTimer > 0;
            if (this.visualize) {
                --this.visualizationTimer;
            }
            this.coldHeatLevel = HeatUtil.getHeatLevelForTemperature(this.coldHeatExchanger.getTemperature());
            this.hotHeatLevel = HeatUtil.getHeatLevelForTemperature(this.hotHeatExchanger.getTemperature());
        }
    }

    @Override
    public void onBlockRotated() {
        this.visualizationTimer = 60;
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.updateConnections();
    }

    private void updateConnections() {
        List<Pair<EnumFacing, IAirHandler>> connections = this.getAirHandler(null).getConnectedPneumatics();
        Arrays.fill(this.sidesConnected, false);
        for (Pair<EnumFacing, IAirHandler> entry : connections) {
            this.sidesConnected[((EnumFacing)entry.getKey()).ordinal()] = true;
        }
    }

    @Override
    protected boolean shouldRerenderChunkOnDescUpdate() {
        return true;
    }

    @Override
    public int getHeatLevelForTintIndex(int tintIndex) {
        switch (tintIndex) {
            case 0: {
                return this.visualize ? 20 : this.hotHeatLevel;
            }
            case 1: {
                return this.visualize ? 0 : this.coldHeatLevel;
            }
        }
        return -1;
    }
}

