/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.client.trackerInfo.detailed;

import pregenerator.base.api.misc.IRenderHelper;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.impl.client.trackerInfo.detailed.DetailedEntry;
import pregenerator.impl.tracking.WorldTracker;

public class BlockTicksEntry
extends DetailedEntry {
    int value;
    int average;

    public BlockTicksEntry() {
        this.register();
    }

    @Override
    public String getName() {
        return "BlockTicks";
    }

    @Override
    public void writeServer(IWriteableBuffer buf) {
        WorldTracker tracker = this.getWorld();
        buf.writeInt(tracker != null ? tracker.getAverageBlockTicks() : 0);
        buf.writeInt(tracker != null ? tracker.getBlockTicks() : 0);
    }

    @Override
    public void readClient(IReadableBuffer buf) {
        this.average = buf.readInt();
        this.value = buf.readInt();
    }

    @Override
    public int getYOffset() {
        return 12;
    }

    @Override
    public void render(int x, int y, float progress, int width, IRenderHelper helper) {
        helper.renderText(x - (width - 25), y, width, "Current BlockTicks: " + this.value);
        int actual = this.average;
        progress = this.clamp(0.0f, 1.0f, (float)actual / 65536.0f);
        int progresBar = (int)(progress * (float)width);
        helper.renderBar(x - width / 2, y, width, progresBar, "Average BlockTicks: " + actual + " / 65536");
        actual = this.value;
        progress = this.clamp(0.0f, 1.0f, (float)actual / 65536.0f);
        progresBar = (int)(progress * (float)width);
        helper.renderBar(x - width / 2, y += 6, width, progresBar, "BlockTicks: " + actual + " / 65536");
    }
}

