/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.structure;

import java.util.ArrayList;
import java.util.List;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.structure.StructureManager;

public class WhipeStructuresSubCommand
extends BasePregenCommand {
    public WhipeStructuresSubCommand() {
        super(1);
        this.addDescription(0, "(Optional) Dimension: Which dimension the Structures should be resetted in");
    }

    @Override
    public String getName() {
        return "resetAllStructures";
    }

    @Override
    public String getDescription() {
        return "Deletes all the Generated structures";
    }

    @Override
    public int getRequiredParameterCount() {
        return 0;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        int dim = WhipeStructuresSubCommand.getDimension(container, WhipeStructuresSubCommand.getArg(args, 0));
        if (!WhipeStructuresSubCommand.isDimensionValid(dim)) {
            container.sendChatMessage("Dimension [" + dim + "] is not registered");
            return;
        }
        StructureManager.instance.createSaveZone(0, 0, 60000000, "All", dim);
        StructureManager.instance.clearAllZones(dim, "All");
        container.sendChatMessage("Removed All Structures and all SaveZones so they will respawn properly in dim " + dim);
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0) {
            return WhipeStructuresSubCommand.getBestMatch(args, CompleterHelper.STRUCTURE_DIMENSION);
        }
        return new ArrayList<String>();
    }
}

