/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.model.IAnimationLoader;
import net.malisis.core.renderer.model.IModelLoader;
import net.malisis.core.renderer.model.loader.AnimationImporter;
import net.malisis.core.renderer.model.loader.ObjFileImporter;
import net.malisis.core.renderer.model.loader.TextureModelLoader;
import net.malisis.core.util.Timer;
import net.minecraft.util.ResourceLocation;

public class MalisisModel
implements ITransformable.Translate,
ITransformable.Rotate,
ITransformable.Scale,
Iterable<Shape> {
    protected Map<String, Shape> shapes = Maps.newHashMap();
    protected Multimap<String, Animation<Shape>> animations = ArrayListMultimap.create();

    public MalisisModel() {
    }

    public MalisisModel(Shape ... shapes) {
        this.addShapes(shapes);
    }

    public MalisisModel(IModelLoader loader) {
        this.load(loader);
    }

    public MalisisModel(IModelLoader loader, IAnimationLoader animLoader) {
        this.load(loader);
        this.load(animLoader);
    }

    public MalisisModel(ResourceLocation resource) {
        if (resource == null) {
            return;
        }
        IModelLoader loader = null;
        AnimationImporter animLoader = null;
        if (resource.func_110623_a().endsWith(".obj")) {
            loader = new ObjFileImporter(resource);
            animLoader = new AnimationImporter(new ResourceLocation(resource.toString() + ".anim"));
        }
        if (resource.func_110623_a().endsWith(".png")) {
            loader = new TextureModelLoader(resource);
        }
        if (loader != null) {
            this.load(loader);
        } else {
            MalisisCore.log.error("[MalisisModel] No loader determined for {}.", (Object)resource.func_110623_a());
        }
        if (animLoader != null) {
            this.load(animLoader);
        }
    }

    protected void load(IModelLoader loader) {
        if (loader == null) {
            return;
        }
        this.shapes = loader.getShapes();
        this.storeState();
    }

    protected void load(IAnimationLoader loader) {
        try {
            this.animations = loader.getAnimations(this.shapes);
        }
        catch (Exception e) {
            MalisisCore.log.error("Failed to get the animations for the model :", (Throwable)e);
        }
    }

    public void addShapes(Shape ... shapes) {
        for (Shape shape : shapes) {
            this.addShape(shape);
        }
    }

    public void addShape(Shape shape) {
        this.addShape("shape_" + (this.shapes.size() + 1), shape);
    }

    public void addShape(String name, Shape shape) {
        if (shape == null) {
            return;
        }
        this.shapes.put(name.toLowerCase(), shape);
    }

    public Shape getShape(String name) {
        return this.shapes.get(name.toLowerCase());
    }

    public Set<String> getShapeNames() {
        return this.shapes.keySet();
    }

    public void addAnimations(Animation<Shape> ... animations) {
        for (Animation<Shape> anim : animations) {
            this.addAnimation(anim);
        }
    }

    public void addAnimation(Animation<Shape> animation) {
        this.addAnimation("animation_" + (this.animations.size() + 1), animation);
    }

    public void addAnimation(String name, Animation<Shape> animation) {
        this.animations.put((Object)name, animation);
    }

    public Collection<Animation<Shape>> getAnimation(String name) {
        return (Collection)MoreObjects.firstNonNull((Object)this.animations.get((Object)name), (Object)ImmutableList.of());
    }

    public Set<String> getAnimatedShapes() {
        HashSet animatedShapes = Sets.newHashSet();
        for (Animation anim : this.animations.values()) {
            for (Map.Entry<String, Shape> entry : this.shapes.entrySet()) {
                if (entry.getValue() != anim.getTransformable()) continue;
                animatedShapes.add(entry.getKey());
            }
        }
        return animatedShapes;
    }

    public Set<String> getAnimationsList() {
        return this.animations.keySet();
    }

    public void render(MalisisRenderer<?> renderer) {
        this.render(renderer, (RenderParameters)null);
    }

    public void render(MalisisRenderer<?> renderer, RenderParameters rp) {
        for (String name : this.shapes.keySet()) {
            this.render(renderer, name, rp);
        }
    }

    public void render(MalisisRenderer<?> renderer, String name) {
        this.render(renderer, name, null);
    }

    public void render(MalisisRenderer<?> renderer, String name, RenderParameters rp) {
        Shape shape = this.getShape(name);
        if (shape != null) {
            renderer.drawShape(shape, rp);
        }
    }

    public boolean animate(String name, Timer timer) {
        boolean finished = true;
        for (Animation<Shape> anim : this.getAnimation(name)) {
            finished &= this.animate(anim, timer) && !anim.persistance();
        }
        return finished;
    }

    public boolean animate(Animation<Shape> animation, Timer timer) {
        animation.animate(timer);
        return animation.isFinished();
    }

    public void storeState() {
        for (Shape s : this) {
            s.storeState();
        }
    }

    public void resetState() {
        for (Shape s : this) {
            s.resetState();
        }
    }

    @Override
    public void translate(float x, float y, float z) {
        for (Shape s : this) {
            s.translate(x, y, z);
        }
    }

    @Override
    public void rotate(float angle, float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        for (Shape s : this) {
            s.rotate(angle, x, y, z, offsetX, offsetY, offsetZ);
        }
    }

    @Override
    public void scale(float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        for (Shape s : this) {
            s.scale(x, y, z, offsetX, offsetY, offsetZ);
        }
    }

    @Override
    public Iterator<Shape> iterator() {
        return this.shapes.values().iterator();
    }
}

