/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraftforge.common.model.TRSRTransformation;

public class TransformBuilder {
    private Vector3f translation;
    private Quat4f leftRot;
    private Vector3f scale;
    private Quat4f rightRot;

    public TransformBuilder translate(float x, float y, float z) {
        this.translation = new Vector3f(x, y, z);
        return this;
    }

    public TransformBuilder scale(float x, float y, float z) {
        this.scale = new Vector3f(x, y, z);
        return this;
    }

    public TransformBuilder scale(float s) {
        this.scale = new Vector3f(s, s, s);
        return this;
    }

    public TransformBuilder rotate(float x, float y, float z) {
        this.leftRot = TRSRTransformation.quatFromXYZ((float)((float)Math.toRadians(x)), (float)((float)Math.toRadians(y)), (float)((float)Math.toRadians(z)));
        return this;
    }

    public TransformBuilder rotateAfter(float x, float y, float z) {
        this.rightRot = TRSRTransformation.quatFromXYZ((float)((float)Math.toRadians(x)), (float)((float)Math.toRadians(y)), (float)((float)Math.toRadians(z)));
        return this;
    }

    public Matrix4f get() {
        return new TRSRTransformation(this.translation, this.leftRot, this.scale, this.rightRot).getMatrix();
    }
}

