/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.book;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import vazkii.patchouli.common.book.BookRegistry;

public class BookFolderLoader {
    public static File loadDir;

    public static void setup(File instanceDir) {
        loadDir = new File(instanceDir, "patchouli_books");
        if (!loadDir.exists()) {
            loadDir.mkdir();
        } else if (!loadDir.isDirectory()) {
            throw new RuntimeException(loadDir.getAbsolutePath() + " is a file, not a folder, aborting. Please delete this file or move it elsewhere if it has important contents.");
        }
    }

    public static void findBooks() {
        File[] subdirs;
        ModContainer mod = Loader.instance().activeModContainer();
        for (File dir : subdirs = loadDir.listFiles(File::isDirectory)) {
            File bookJson = new File(dir, "book.json");
            if (!bookJson.exists()) continue;
            try {
                ResourceLocation res = new ResourceLocation("patchouli", dir.getName());
                FileInputStream stream = new FileInputStream(bookJson);
                BookRegistry.INSTANCE.loadBook(mod, res, stream, true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

