/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelay;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayEnergy;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityLaserRelayFluids
extends TileEntityLaserRelay {
    public final ConcurrentHashMap<EnumFacing, TileEntity> handlersAround = new ConcurrentHashMap();
    private final IFluidHandler[] fluidHandlers = new IFluidHandler[6];
    private TileEntityLaserRelayEnergy.Mode mode = TileEntityLaserRelayEnergy.Mode.BOTH;

    public TileEntityLaserRelayFluids() {
        super("laserRelayFluids", LaserType.FLUID);
        for (int i = 0; i < this.fluidHandlers.length; ++i) {
            final EnumFacing facing = EnumFacing.values()[i];
            this.fluidHandlers[i] = new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return new IFluidTankProperties[0];
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return TileEntityLaserRelayFluids.this.transmitFluid(facing, resource, doFill);
                }

                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    return null;
                }

                public FluidStack drain(int maxDrain, boolean doDrain) {
                    return null;
                }
            };
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K && this.mode == TileEntityLaserRelayEnergy.Mode.INPUT_ONLY) {
            for (EnumFacing side : this.handlersAround.keySet()) {
                WorldUtil.doFluidInteraction(this.handlersAround.get(side), this, side.func_176734_d(), Integer.MAX_VALUE);
            }
        }
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        Network network;
        HashMap<EnumFacing, TileEntity> old = new HashMap<EnumFacing, TileEntity>(this.handlersAround);
        boolean change = false;
        this.handlersAround.clear();
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity tile;
            BlockPos pos = this.func_174877_v().func_177972_a(side);
            if (!this.field_145850_b.func_175667_e(pos) || (tile = this.field_145850_b.func_175625_s(pos)) == null || tile instanceof TileEntityLaserRelay || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d())) continue;
            this.handlersAround.put(side, tile);
            TileEntity oldTile = (TileEntity)old.get(side);
            if (oldTile != null && tile.equals(oldTile)) continue;
            change = true;
        }
        if ((change || old.size() != this.handlersAround.size()) && (network = this.getNetwork()) != null) {
            ++network.changeAmount;
        }
    }

    @Override
    public IFluidHandler getFluidHandler(EnumFacing facing) {
        return this.fluidHandlers[facing == null ? 0 : facing.ordinal()];
    }

    private int transmitFluid(EnumFacing from, FluidStack stack, boolean doFill) {
        Network network;
        int transmitted = 0;
        if (stack != null && this.mode != TileEntityLaserRelayEnergy.Mode.OUTPUT_ONLY && (network = this.getNetwork()) != null) {
            transmitted = this.transferFluidToReceiverInNeed(from, network, stack, doFill);
        }
        return transmitted;
    }

    private int transferFluidToReceiverInNeed(EnumFacing from, Network network, FluidStack stack, boolean doFill) {
        int transmitted = 0;
        HashSet<BlockPos> alreadyChecked = new HashSet<BlockPos>();
        HashSet<TileEntityLaserRelayFluids> relaysThatWork = new HashSet<TileEntityLaserRelayFluids>();
        int totalReceiverAmount = 0;
        for (IConnectionPair pair : network.connections) {
            for (BlockPos relay : pair.getPositions()) {
                if (relay == null || !this.field_145850_b.func_175667_e(relay) || alreadyChecked.contains(relay)) continue;
                alreadyChecked.add(relay);
                TileEntity relayTile = this.field_145850_b.func_175625_s(relay);
                if (!(relayTile instanceof TileEntityLaserRelayFluids)) continue;
                TileEntityLaserRelayFluids theRelay = (TileEntityLaserRelayFluids)relayTile;
                if (theRelay.mode == TileEntityLaserRelayEnergy.Mode.INPUT_ONLY) continue;
                boolean workedOnce = false;
                for (EnumFacing facing : theRelay.handlersAround.keySet()) {
                    IFluidHandler cap;
                    EnumFacing opp;
                    TileEntity tile;
                    if (theRelay == this && facing == from || !(tile = theRelay.handlersAround.get(facing)).hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opp = facing.func_176734_d()) || (cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opp)) == null || cap.fill(stack, false) <= 0) continue;
                    ++totalReceiverAmount;
                    workedOnce = true;
                }
                if (!workedOnce) continue;
                relaysThatWork.add(theRelay);
            }
        }
        if (totalReceiverAmount > 0 && !relaysThatWork.isEmpty()) {
            int amountPer = stack.amount / totalReceiverAmount;
            if (amountPer <= 0) {
                amountPer = stack.amount;
            }
            for (TileEntityLaserRelayFluids theRelay : relaysThatWork) {
                for (Map.Entry<EnumFacing, TileEntity> receiver : theRelay.handlersAround.entrySet()) {
                    IFluidHandler cap;
                    if (receiver == null) continue;
                    EnumFacing side = receiver.getKey();
                    EnumFacing opp = side.func_176734_d();
                    TileEntity tile = receiver.getValue();
                    if (alreadyChecked.contains(tile.func_174877_v())) continue;
                    alreadyChecked.add(tile.func_174877_v());
                    if (theRelay == this && side == from) continue;
                    if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opp) && (cap = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, opp)) != null) {
                        FluidStack copy = stack.copy();
                        copy.amount = amountPer;
                        transmitted += cap.fill(copy, doFill);
                    }
                    if (transmitted < stack.amount) continue;
                    return transmitted;
                }
            }
        }
        return transmitted;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getExtraDisplayString() {
        return StringUtil.localize("info.actuallyadditions.laserRelay.fluid.extra") + ": " + TextFormatting.DARK_RED + StringUtil.localize(this.mode.name) + TextFormatting.RESET;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getCompassDisplayString() {
        return TextFormatting.GREEN + StringUtil.localize("info.actuallyadditions.laserRelay.energy.display");
    }

    @Override
    public void onCompassAction(EntityPlayer player) {
        this.mode = this.mode.getNext();
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74778_a("Mode", this.mode.toString());
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        String modeStrg;
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK && (modeStrg = compound.func_74779_i("Mode")) != null && !modeStrg.isEmpty()) {
            this.mode = TileEntityLaserRelayEnergy.Mode.valueOf(modeStrg);
        }
    }
}

